/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.edit;

import com.google.common.collect.Lists;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPageSelection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PageSelection
extends InternalPageSelection {
    public static PageSelection allPages() {
        return new PageSelection();
    }

    public static PageSelection singlePage(int pageIndex) {
        PageSelection ps = new PageSelection();
        ps.setPageList(Lists.newArrayList((Object[])new Integer[]{pageIndex}));
        return ps;
    }

    public static PageSelection firstPage() {
        PageSelection ps = new PageSelection();
        ps.setPageList(Lists.newArrayList((Object[])new Integer[]{0}));
        return ps;
    }

    public static PageSelection lastPage() {
        PageSelection ps = new PageSelection();
        ps.setPageList(Lists.newArrayList((Object[])new Integer[]{-1}));
        return ps;
    }

    public static PageSelection pageRange(int startIndex, int endIndex) {
        PageSelection ps = new PageSelection();
        ps.setPageList(IntStream.range(startIndex, endIndex).boxed().collect(Collectors.toList()));
        return ps;
    }

    public static PageSelection pageRange(List<Integer> pageList) {
        PageSelection ps = new PageSelection();
        ps.setPageList(pageList);
        return ps;
    }

    private void setPageList(List<Integer> pageList) {
        this.pagesList = Lists.newArrayList(pageList);
    }
}

