/*
 * Decompiled with CFR 0.152.
 */
package xcrash;

import android.text.TextUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import xcrash.FileManager;
import xcrash.XCrash;

public class TombstoneManager {
    private TombstoneManager() {
    }

    public static boolean appendSection(String logPath, String key, String content) {
        if (TextUtils.isEmpty((CharSequence)logPath) || TextUtils.isEmpty((CharSequence)key) || content == null) {
            return false;
        }
        return FileManager.getInstance().appendText(logPath, "\n\n" + key + ":\n" + content + "\n\n");
    }

    public static boolean isJavaCrash(File log) {
        return log.getName().endsWith(".java.xcrash");
    }

    public static boolean isNativeCrash(File log) {
        return log.getName().endsWith(".native.xcrash");
    }

    public static boolean isAnr(File log) {
        return log.getName().endsWith(".anr.xcrash");
    }

    public static File[] getJavaTombstones() {
        return TombstoneManager.getTombstones(new String[]{".java.xcrash"});
    }

    public static File[] getNativeTombstones() {
        return TombstoneManager.getTombstones(new String[]{".native.xcrash"});
    }

    public static File[] getAnrTombstones() {
        return TombstoneManager.getTombstones(new String[]{".anr.xcrash"});
    }

    public static File[] getAllTombstones() {
        return TombstoneManager.getTombstones(new String[]{".java.xcrash", ".native.xcrash", ".anr.xcrash"});
    }

    public static boolean deleteTombstone(File file) {
        return FileManager.getInstance().recycleLogFile(file);
    }

    public static boolean deleteTombstone(String path) {
        return FileManager.getInstance().recycleLogFile(new File(path));
    }

    public static boolean clearJavaTombstones() {
        return TombstoneManager.clearTombstones(new String[]{".java.xcrash"});
    }

    public static boolean clearNativeTombstones() {
        return TombstoneManager.clearTombstones(new String[]{".native.xcrash"});
    }

    public static boolean clearAnrTombstones() {
        return TombstoneManager.clearTombstones(new String[]{".anr.xcrash"});
    }

    public static boolean clearAllTombstones() {
        return TombstoneManager.clearTombstones(new String[]{".java.xcrash", ".native.xcrash", ".anr.xcrash"});
    }

    private static File[] getTombstones(final String[] logPrefixes) {
        String logDir = XCrash.getLogDir();
        if (logDir == null) {
            return new File[0];
        }
        File dir = new File(logDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return new File[0];
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith("tombstone_")) {
                    return false;
                }
                for (String logPrefix : logPrefixes) {
                    if (!name.endsWith(logPrefix)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files == null) {
            return new File[0];
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        return files;
    }

    private static boolean clearTombstones(final String[] logPrefixes) {
        String logDir = XCrash.getLogDir();
        if (logDir == null) {
            return false;
        }
        File dir = new File(logDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith("tombstone_")) {
                    return false;
                }
                for (String logPrefix : logPrefixes) {
                    if (!name.endsWith(logPrefix)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File f : files) {
            if (FileManager.getInstance().recycleLogFile(f)) continue;
            success = false;
        }
        return success;
    }
}

