/*
 * Decompiled with CFR 0.152.
 */
package xcrash;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.Map;
import xcrash.ActivityMonitor;
import xcrash.FileManager;
import xcrash.ICrashCallback;
import xcrash.ILibLoader;
import xcrash.TombstoneManager;
import xcrash.Util;
import xcrash.XCrash;

@SuppressLint(value={"StaticFieldLeak"})
class NativeHandler {
    private static final String TAG = "xcrash";
    private static final NativeHandler instance = new NativeHandler();
    private long anrTimeoutMs = 25000L;
    private Context ctx;
    private boolean crashRethrow;
    private ICrashCallback crashCallback;
    private boolean anrEnable;
    private boolean anrCheckProcessState;
    private ICrashCallback anrCallback;
    private ICrashCallback anrFastCallback;
    private boolean initNativeLibOk = false;

    private NativeHandler() {
    }

    static NativeHandler getInstance() {
        return instance;
    }

    int initialize(Context ctx, ILibLoader libLoader, String appId, String appVersion, String logDir, boolean crashEnable, boolean crashRethrow, int crashLogcatSystemLines, int crashLogcatEventsLines, int crashLogcatMainLines, boolean crashDumpElfHash, boolean crashDumpMap, boolean crashDumpFds, boolean crashDumpNetworkInfo, boolean crashDumpAllThreads, int crashDumpAllThreadsCountMax, String[] crashDumpAllThreadsWhiteList, ICrashCallback crashCallback, boolean anrEnable, boolean anrRethrow, boolean anrCheckProcessState, int anrLogcatSystemLines, int anrLogcatEventsLines, int anrLogcatMainLines, boolean anrDumpFds, boolean anrDumpNetworkInfo, ICrashCallback anrCallback, ICrashCallback anrFastCallback) {
        if (libLoader == null) {
            try {
                System.loadLibrary(TAG);
            }
            catch (Throwable e) {
                XCrash.getLogger().e(TAG, "NativeHandler System.loadLibrary failed", e);
                return -2;
            }
        }
        try {
            libLoader.loadLibrary(TAG);
        }
        catch (Throwable e) {
            XCrash.getLogger().e(TAG, "NativeHandler ILibLoader.loadLibrary failed", e);
            return -2;
        }
        this.ctx = ctx;
        this.crashRethrow = crashRethrow;
        this.crashCallback = crashCallback;
        this.anrEnable = anrEnable;
        this.anrCheckProcessState = anrCheckProcessState;
        this.anrCallback = anrCallback;
        this.anrFastCallback = anrFastCallback;
        this.anrTimeoutMs = anrRethrow ? 25000L : 45000L;
        try {
            int r = NativeHandler.nativeInit(Build.VERSION.SDK_INT, Build.VERSION.RELEASE, Util.getAbiList(), Build.MANUFACTURER, Build.BRAND, Util.getMobileModel(), Build.FINGERPRINT, appId, appVersion, ctx.getApplicationInfo().nativeLibraryDir, logDir, crashEnable, crashRethrow, crashLogcatSystemLines, crashLogcatEventsLines, crashLogcatMainLines, crashDumpElfHash, crashDumpMap, crashDumpFds, crashDumpNetworkInfo, crashDumpAllThreads, crashDumpAllThreadsCountMax, crashDumpAllThreadsWhiteList, anrEnable, anrRethrow, anrLogcatSystemLines, anrLogcatEventsLines, anrLogcatMainLines, anrDumpFds, anrDumpNetworkInfo);
            if (r != 0) {
                XCrash.getLogger().e(TAG, "NativeHandler init failed");
                return -3;
            }
            this.initNativeLibOk = true;
            return 0;
        }
        catch (Throwable e) {
            XCrash.getLogger().e(TAG, "NativeHandler init failed", e);
            return -3;
        }
    }

    void notifyJavaCrashed() {
        if (this.initNativeLibOk && this.anrEnable) {
            NativeHandler.nativeNotifyJavaCrashed();
        }
    }

    void testNativeCrash(boolean runInNewThread) {
        if (this.initNativeLibOk) {
            NativeHandler.nativeTestCrash(runInNewThread ? 1 : 0);
        }
    }

    private static String getStacktraceByThreadName(boolean isMainThread, String threadName) {
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                Thread thd = entry.getKey();
                if ((!isMainThread || !thd.getName().equals("main")) && (isMainThread || !thd.getName().contains(threadName))) continue;
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement element : entry.getValue()) {
                    sb.append("    at ").append(element.toString()).append("\n");
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            XCrash.getLogger().e(TAG, "NativeHandler getStacktraceByThreadName failed", e);
        }
        return null;
    }

    private static void crashCallback(String logPath, String emergency, boolean dumpJavaStacktrace, boolean isMainThread, String threadName) {
        ICrashCallback callback;
        if (!TextUtils.isEmpty((CharSequence)logPath)) {
            String stacktrace;
            if (dumpJavaStacktrace && !TextUtils.isEmpty((CharSequence)(stacktrace = NativeHandler.getStacktraceByThreadName(isMainThread, threadName)))) {
                TombstoneManager.appendSection(logPath, "java stacktrace", stacktrace);
            }
            TombstoneManager.appendSection(logPath, "memory info", Util.getProcessMemoryInfo());
            TombstoneManager.appendSection(logPath, "foreground", ActivityMonitor.getInstance().isApplicationForeground() ? "yes" : "no");
        }
        if ((callback = NativeHandler.getInstance().crashCallback) != null) {
            try {
                callback.onCrash(logPath, emergency);
            }
            catch (Exception e) {
                XCrash.getLogger().w(TAG, "NativeHandler native crash callback.onCrash failed", e);
            }
        }
        if (!NativeHandler.getInstance().crashRethrow) {
            ActivityMonitor.getInstance().finishAllActivities();
        }
    }

    private static void traceCallbackBeforeDump() {
        Log.i((String)TAG, (String)("trace fast callback time: " + System.currentTimeMillis()));
        ICrashCallback anrFastCallback = NativeHandler.getInstance().anrFastCallback;
        if (anrFastCallback != null) {
            try {
                anrFastCallback.onCrash(null, null);
            }
            catch (Exception e) {
                XCrash.getLogger().w(TAG, "NativeHandler ANR callback.onCrash failed", e);
            }
        }
    }

    private static void traceCallback(String logPath, String emergency) {
        Log.i((String)TAG, (String)("trace slow callback time: " + System.currentTimeMillis()));
        if (TextUtils.isEmpty((CharSequence)logPath)) {
            return;
        }
        TombstoneManager.appendSection(logPath, "memory info", Util.getProcessMemoryInfo());
        TombstoneManager.appendSection(logPath, "foreground", ActivityMonitor.getInstance().isApplicationForeground() ? "yes" : "no");
        if (NativeHandler.getInstance().anrCheckProcessState && !Util.checkProcessAnrState(NativeHandler.getInstance().ctx, NativeHandler.getInstance().anrTimeoutMs)) {
            FileManager.getInstance().recycleLogFile(new File(logPath));
            return;
        }
        if (!FileManager.getInstance().maintainAnr()) {
            return;
        }
        File traceFile = new File(logPath);
        String anrLogPath = logPath.substring(0, logPath.length() - ".trace.xcrash".length()) + ".anr.xcrash";
        File anrFile = new File(anrLogPath);
        if (!traceFile.renameTo(anrFile)) {
            FileManager.getInstance().recycleLogFile(traceFile);
            return;
        }
        ICrashCallback callback = NativeHandler.getInstance().anrCallback;
        if (callback != null) {
            try {
                callback.onCrash(anrLogPath, emergency);
            }
            catch (Exception e) {
                XCrash.getLogger().w(TAG, "NativeHandler ANR callback.onCrash failed", e);
            }
        }
    }

    private static native int nativeInit(int var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, boolean var11, boolean var12, int var13, int var14, int var15, boolean var16, boolean var17, boolean var18, boolean var19, boolean var20, int var21, String[] var22, boolean var23, boolean var24, int var25, int var26, int var27, boolean var28, boolean var29);

    private static native void nativeNotifyJavaCrashed();

    private static native void nativeTestCrash(int var0);
}

