/*
 * Decompiled with CFR 0.152.
 */
package xcrash;

import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xcrash.Util;
import xcrash.XCrash;

public class TombstoneParser {
    public static final String keyTombstoneMaker = "Tombstone maker";
    public static final String keyCrashType = "Crash type";
    public static final String keyStartTime = "Start time";
    public static final String keyCrashTime = "Crash time";
    public static final String keyAppId = "App ID";
    public static final String keyAppVersion = "App version";
    public static final String keyRooted = "Rooted";
    public static final String keyApiLevel = "API level";
    public static final String keyOsVersion = "OS version";
    public static final String keyKernelVersion = "Kernel version";
    public static final String keyAbiList = "ABI list";
    public static final String keyManufacturer = "Manufacturer";
    public static final String keyBrand = "Brand";
    public static final String keyModel = "Model";
    public static final String keyBuildFingerprint = "Build fingerprint";
    public static final String keyAbi = "ABI";
    public static final String keyProcessId = "pid";
    public static final String keyThreadId = "tid";
    public static final String keyProcessName = "pname";
    public static final String keyThreadName = "tname";
    public static final String keySignal = "signal";
    public static final String keyCode = "code";
    public static final String keyFaultAddr = "fault addr";
    public static final String keyAbortMessage = "Abort message";
    public static final String keyRegisters = "registers";
    public static final String keyBacktrace = "backtrace";
    public static final String keyBuildId = "build id";
    public static final String keyStack = "stack";
    public static final String keyMemoryNear = "memory near";
    public static final String keyMemoryMap = "memory map";
    public static final String keyLogcat = "logcat";
    public static final String keyOpenFiles = "open files";
    public static final String keyNetworkInfo = "network info";
    public static final String keyMemoryInfo = "memory info";
    public static final String keyOtherThreads = "other threads";
    public static final String keyJavaStacktrace = "java stacktrace";
    public static final String keyXCrashError = "xcrash error";
    public static final String keyForeground = "foreground";
    public static final String keyXCrashErrorDebug = "xcrash error debug";
    private static final Pattern patHeadItem = Pattern.compile("^(.*):\\s'(.*?)'$");
    private static final Pattern patProcessThread = Pattern.compile("^pid:\\s(.*),\\stid:\\s(.*),\\sname:\\s(.*)\\s+>>>\\s(.*)\\s<<<$");
    private static final Pattern patProcess = Pattern.compile("^pid:\\s(.*)\\s+>>>\\s(.*)\\s<<<$");
    private static final Pattern patSignalCode = Pattern.compile("^signal\\s(.*),\\scode\\s(.*),\\sfault\\saddr\\s(.*)$");
    private static final Pattern patAppVersionProcessName = Pattern.compile("^(\\d{20})_(.*)__(.*)$");
    private static final Set<String> keyHeadItems = new HashSet<String>(Arrays.asList("Tombstone maker", "Crash type", "Start time", "Crash time", "App ID", "App version", "Rooted", "API level", "OS version", "Kernel version", "ABI list", "Manufacturer", "Brand", "Model", "Build fingerprint", "ABI", "Abort message"));
    private static final Set<String> keySections = new HashSet<String>(Arrays.asList("backtrace", "build id", "stack", "memory map", "logcat", "open files", "java stacktrace", "xcrash error", "xcrash error debug"));
    private static final Set<String> keySingleLineSections = new HashSet<String>(Arrays.asList("foreground"));

    private TombstoneParser() {
    }

    public static Map<String, String> parse(File log) throws IOException {
        return TombstoneParser.parse(log.getAbsolutePath(), null);
    }

    public static Map<String, String> parse(String logPath) throws IOException {
        return TombstoneParser.parse(logPath, null);
    }

    public static Map<String, String> parse(String logPath, String emergency) throws IOException {
        BufferedReader br;
        HashMap<String, String> map = new HashMap<String, String>();
        if (logPath != null) {
            br = new BufferedReader(new FileReader(logPath));
            TombstoneParser.parseFromReader(map, br, true);
            br.close();
        }
        if (emergency != null) {
            br = new BufferedReader(new StringReader(emergency));
            TombstoneParser.parseFromReader(map, br, false);
            br.close();
        }
        TombstoneParser.parseFromLogPath(map, logPath);
        String appVersion = (String)map.get(keyAppVersion);
        if (TextUtils.isEmpty((CharSequence)appVersion)) {
            appVersion = XCrash.getAppVersion();
            map.put(keyAppVersion, TextUtils.isEmpty((CharSequence)appVersion) ? "unknown" : appVersion);
        }
        TombstoneParser.addSystemInfo(map);
        return map;
    }

    private static void parseFromLogPath(Map<String, String> map, String logPath) {
        if (logPath == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyCrashTime))) {
            SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
            map.put(keyCrashTime, timeFormatter.format(new Date(new File(logPath).lastModified())));
        }
        String startTime = map.get(keyStartTime);
        String appVersion = map.get(keyAppVersion);
        String processName = map.get(keyProcessName);
        String crashType = map.get(keyCrashType);
        if (TextUtils.isEmpty((CharSequence)startTime) || TextUtils.isEmpty((CharSequence)appVersion) || TextUtils.isEmpty((CharSequence)processName) || TextUtils.isEmpty((CharSequence)crashType)) {
            Matcher matcher;
            String filename = logPath.substring(logPath.lastIndexOf(47) + 1);
            if (filename.isEmpty()) {
                return;
            }
            if (!filename.startsWith("tombstone_")) {
                return;
            }
            if ((filename = filename.substring("tombstone".length() + 1)).endsWith(".java.xcrash")) {
                if (TextUtils.isEmpty((CharSequence)crashType)) {
                    map.put(keyCrashType, "java");
                }
                filename = filename.substring(0, filename.length() - ".java.xcrash".length());
            } else if (filename.endsWith(".native.xcrash")) {
                if (TextUtils.isEmpty((CharSequence)crashType)) {
                    map.put(keyCrashType, "native");
                }
                filename = filename.substring(0, filename.length() - ".native.xcrash".length());
            } else if (filename.endsWith(".anr.xcrash")) {
                if (TextUtils.isEmpty((CharSequence)crashType)) {
                    map.put(keyCrashType, "anr");
                }
                filename = filename.substring(0, filename.length() - ".anr.xcrash".length());
            } else {
                return;
            }
            if ((TextUtils.isEmpty((CharSequence)startTime) || TextUtils.isEmpty((CharSequence)appVersion) || TextUtils.isEmpty((CharSequence)processName)) && (matcher = patAppVersionProcessName.matcher(filename)).find() && matcher.groupCount() == 3) {
                if (TextUtils.isEmpty((CharSequence)startTime)) {
                    long crashTimeLong = Long.parseLong(matcher.group(1), 10) / 1000L;
                    SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
                    map.put(keyStartTime, timeFormatter.format(new Date(crashTimeLong)));
                }
                if (TextUtils.isEmpty((CharSequence)appVersion)) {
                    map.put(keyAppVersion, matcher.group(2));
                }
                if (TextUtils.isEmpty((CharSequence)processName)) {
                    map.put(keyProcessName, matcher.group(3));
                }
            }
        }
    }

    private static void addSystemInfo(Map<String, String> map) {
        if (TextUtils.isEmpty((CharSequence)map.get(keyAppId))) {
            map.put(keyAppId, XCrash.getAppId());
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyTombstoneMaker))) {
            map.put(keyTombstoneMaker, "xCrash 3.0.0");
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyRooted))) {
            map.put(keyRooted, Util.isRoot() ? "Yes" : "No");
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyApiLevel))) {
            map.put(keyApiLevel, String.valueOf(Build.VERSION.SDK_INT));
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyOsVersion))) {
            map.put(keyOsVersion, Build.VERSION.RELEASE);
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyBuildFingerprint))) {
            map.put(keyModel, Build.FINGERPRINT);
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyManufacturer))) {
            map.put(keyManufacturer, Build.MANUFACTURER);
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyBrand))) {
            map.put(keyBrand, Build.BRAND);
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyModel))) {
            map.put(keyModel, Util.getMobileModel());
        }
        if (TextUtils.isEmpty((CharSequence)map.get(keyAbiList))) {
            map.put(keyAbiList, Util.getAbiList());
        }
    }

    private static String readLineInBinary(BufferedReader br) throws IOException {
        try {
            br.mark(2);
        }
        catch (Exception ignored) {
            return br.readLine();
        }
        try {
            for (int i = 0; i < 2; ++i) {
                int c = br.read();
                if (c == -1) {
                    br.reset();
                    return null;
                }
                if (c <= 0) continue;
                br.reset();
                return br.readLine();
            }
            br.reset();
            return null;
        }
        catch (Exception ignored) {
            br.reset();
            return br.readLine();
        }
    }

    private static void parseFromReader(Map<String, String> map, BufferedReader br, boolean binary) throws IOException {
        boolean last;
        String sectionTitle = null;
        StringBuilder sectionContent = new StringBuilder();
        String sectionContentEnding = "";
        boolean sectionContentOutdent = false;
        boolean sectionContentAppend = false;
        Status status = Status.UNKNOWN;
        String line = binary ? TombstoneParser.readLineInBinary(br) : br.readLine();
        boolean bl = last = line == null;
        while (!last) {
            String next = binary ? TombstoneParser.readLineInBinary(br) : br.readLine();
            last = next == null;
            switch (status) {
                case UNKNOWN: {
                    if (line.equals("*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***")) {
                        status = Status.HEAD;
                        break;
                    }
                    if (line.equals("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---")) {
                        status = Status.SECTION;
                        sectionTitle = keyOtherThreads;
                        sectionContentEnding = "+++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++";
                        sectionContentOutdent = false;
                        sectionContentAppend = false;
                        sectionContent.append(line).append('\n');
                        break;
                    }
                    if (line.length() <= 1 || !line.endsWith(":")) break;
                    status = Status.SECTION;
                    sectionTitle = line.substring(0, line.length() - 1);
                    sectionContentEnding = "";
                    if (keySections.contains(sectionTitle)) {
                        sectionContentOutdent = sectionTitle.equals(keyBacktrace) || sectionTitle.equals(keyBuildId) || sectionTitle.equals(keyStack) || sectionTitle.equals(keyMemoryMap) || sectionTitle.equals(keyOpenFiles) || sectionTitle.equals(keyJavaStacktrace) || sectionTitle.equals(keyXCrashErrorDebug);
                        sectionContentAppend = sectionTitle.equals(keyXCrashError);
                        break;
                    }
                    if (sectionTitle.equals(keyMemoryInfo)) {
                        sectionContentOutdent = false;
                        sectionContentAppend = true;
                        break;
                    }
                    if (sectionTitle.startsWith("memory near ")) {
                        sectionTitle = keyMemoryNear;
                        sectionContentOutdent = false;
                        sectionContentAppend = true;
                        sectionContent.append(line).append('\n');
                        break;
                    }
                    sectionContentOutdent = false;
                    sectionContentAppend = false;
                    break;
                }
                case HEAD: {
                    Matcher matcher;
                    if (line.startsWith("pid: ")) {
                        matcher = patProcessThread.matcher(line);
                        if (matcher.find() && matcher.groupCount() == 4) {
                            TombstoneParser.putKeyValue(map, keyProcessId, matcher.group(1));
                            TombstoneParser.putKeyValue(map, keyThreadId, matcher.group(2));
                            TombstoneParser.putKeyValue(map, keyThreadName, matcher.group(3));
                            TombstoneParser.putKeyValue(map, keyProcessName, matcher.group(4));
                        } else {
                            matcher = patProcess.matcher(line);
                            if (matcher.find() && matcher.groupCount() == 2) {
                                TombstoneParser.putKeyValue(map, keyProcessId, matcher.group(1));
                                TombstoneParser.putKeyValue(map, keyProcessName, matcher.group(2));
                            }
                        }
                    } else if (line.startsWith("signal ")) {
                        matcher = patSignalCode.matcher(line);
                        if (matcher.find() && matcher.groupCount() == 3) {
                            TombstoneParser.putKeyValue(map, keySignal, matcher.group(1));
                            TombstoneParser.putKeyValue(map, keyCode, matcher.group(2));
                            TombstoneParser.putKeyValue(map, keyFaultAddr, matcher.group(3));
                        }
                    } else {
                        matcher = patHeadItem.matcher(line);
                        if (matcher.find() && matcher.groupCount() == 2 && keyHeadItems.contains(matcher.group(1))) {
                            TombstoneParser.putKeyValue(map, matcher.group(1), matcher.group(2));
                        }
                    }
                    if (next != null && (next.startsWith("    r0 ") || next.startsWith("    x0 ") || next.startsWith("    eax ") || next.startsWith("    rax "))) {
                        status = Status.SECTION;
                        sectionTitle = keyRegisters;
                        sectionContentEnding = "";
                        sectionContentOutdent = true;
                        sectionContentAppend = false;
                    }
                    if (next != null && !next.isEmpty()) break;
                    status = Status.UNKNOWN;
                    break;
                }
                case SECTION: {
                    if (line.equals(sectionContentEnding) || last) {
                        if (keySingleLineSections.contains(sectionTitle) && sectionContent.length() > 0 && sectionContent.charAt(sectionContent.length() - 1) == '\n') {
                            sectionContent.deleteCharAt(sectionContent.length() - 1);
                        }
                        TombstoneParser.putKeyValue(map, sectionTitle, sectionContent.toString(), sectionContentAppend);
                        sectionContent.setLength(0);
                        status = Status.UNKNOWN;
                        break;
                    }
                    if (sectionContentOutdent) {
                        if (sectionTitle.equals(keyJavaStacktrace) && line.startsWith(" ")) {
                            line = line.trim();
                        } else if (line.startsWith("    ")) {
                            line = line.substring(4);
                        }
                    }
                    sectionContent.append(line).append('\n');
                    break;
                }
            }
            line = next;
        }
    }

    private static void putKeyValue(Map<String, String> map, String k, String v) {
        TombstoneParser.putKeyValue(map, k, v, false);
    }

    private static void putKeyValue(Map<String, String> map, String k, String v, boolean append) {
        if (k == null || k.isEmpty() || v == null) {
            return;
        }
        String oldValue = map.get(k);
        if (append) {
            map.put(k, oldValue == null ? v : oldValue + v);
        } else if (oldValue == null || oldValue.isEmpty() && !v.isEmpty()) {
            map.put(k, v);
        }
    }

    private static enum Status {
        UNKNOWN,
        HEAD,
        SECTION;

    }
}

