/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitUpdateReporter;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitDetails;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitUpdateReporterManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitUpdateService
extends IntentService {
    private static final String TAG = "SplitUpdateService";

    public SplitUpdateService() {
        super("qigsaw_split_update");
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        if (intent == null) {
            SplitLog.w((String)TAG, (String)"SplitUpdateService receiver null intent!", (Object[])new Object[0]);
            return;
        }
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager == null) {
            SplitLog.w((String)TAG, (String)"SplitInfoManager has not been created!", (Object[])new Object[0]);
            return;
        }
        Collection<SplitInfo> currentSplits = manager.getAllSplitInfo((Context)this);
        if (currentSplits == null) {
            SplitLog.w((String)TAG, (String)"Failed to get splits info of current split-info version!", (Object[])new Object[0]);
            return;
        }
        String newSplitInfoVersion = intent.getStringExtra("new_split_info_version");
        String newSplitInfoPath = intent.getStringExtra("new_split_info_path");
        String oldSplitInfoVersion = manager.getCurrentSplitInfoVersion();
        if (TextUtils.isEmpty((CharSequence)newSplitInfoVersion)) {
            SplitLog.w((String)TAG, (String)"New split-info version null", (Object[])new Object[0]);
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -31);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)newSplitInfoPath)) {
            SplitLog.w((String)TAG, (String)"New split-info path null", (Object[])new Object[0]);
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -32);
            return;
        }
        File newSplitInfoFile = new File(newSplitInfoPath);
        if (!newSplitInfoFile.exists() || !newSplitInfoFile.canWrite()) {
            SplitLog.w((String)TAG, (String)"New split-info file %s is invalid", (Object[])new Object[]{newSplitInfoPath});
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -33);
            return;
        }
        if (newSplitInfoVersion.equals(manager.getCurrentSplitInfoVersion())) {
            SplitLog.w((String)TAG, (String)"New split-info version %s is equals to current version!", (Object[])new Object[]{newSplitInfoVersion});
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -34);
            return;
        }
        SplitDetails splitDetails = manager.createSplitDetailsForJsonFile(newSplitInfoPath);
        if (splitDetails == null) {
            SplitLog.w((String)TAG, (String)"Failed to parse SplitDetails for new split info file!", (Object[])new Object[0]);
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -35);
            return;
        }
        String qigsawId = splitDetails.getQigsawId();
        if (TextUtils.isEmpty((CharSequence)qigsawId) || !qigsawId.equals(SplitBaseInfoProvider.getQigsawId())) {
            SplitLog.w((String)TAG, (String)"New qigsaw-id is not equal to current app, so we could't update splits!", (Object[])new Object[0]);
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -37);
            return;
        }
        ArrayList updateSplits = (ArrayList)splitDetails.getUpdateSplits();
        if (updateSplits == null || updateSplits.isEmpty()) {
            SplitLog.w((String)TAG, (String)"There are no splits need to be updated!", (Object[])new Object[0]);
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -36);
            return;
        }
        SplitLog.w((String)TAG, (String)"Success to check update request, updatedSplitInfoPath: %s, updatedSplitInfoVersion: %s", (Object[])new Object[]{newSplitInfoPath, newSplitInfoVersion});
        if (manager.updateSplitInfoVersion(this.getApplicationContext(), newSplitInfoVersion, newSplitInfoFile)) {
            this.onUpdateOK(oldSplitInfoVersion, newSplitInfoVersion, updateSplits);
        } else {
            this.onUpdateError(oldSplitInfoVersion, newSplitInfoVersion, -38);
        }
    }

    private void onUpdateOK(String oldSplitInfoVersion, String newSplitInfoVersion, List<String> updateSplits) {
        SplitUpdateReporter updateReporter = SplitUpdateReporterManager.getUpdateReporter();
        if (updateReporter != null) {
            updateReporter.onUpdateOK(oldSplitInfoVersion, newSplitInfoVersion, updateSplits);
        }
    }

    private void onUpdateError(String oldSplitInfoVersion, String newSplitInfoVersion, int errorCode) {
        SplitUpdateReporter updateReporter = SplitUpdateReporterManager.getUpdateReporter();
        if (updateReporter != null) {
            updateReporter.onUpdateFailed(oldSplitInfoVersion, newSplitInfoVersion, errorCode);
        }
    }
}

