/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.ProcessUtil;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitUpdateReporter;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionData;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionDataStorageImpl;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitUpdateReporterManager;
import java.io.File;
import java.io.IOException;

final class SplitInfoVersionManagerImpl
implements SplitInfoVersionManager {
    private static final String TAG = "SplitInfoVersionManager";
    private String defaultVersion;
    private File rootDir;
    private String currentVersion;

    static SplitInfoVersionManager createSplitInfoVersionManager(Context context) {
        String defaultVersion = SplitBaseInfoProvider.getDefaultSplitInfoVersion();
        String qigsawId = SplitBaseInfoProvider.getQigsawId();
        return new SplitInfoVersionManagerImpl(context, defaultVersion, qigsawId);
    }

    private SplitInfoVersionManagerImpl(Context context, String defaultVersion, String qigsawId) {
        this.defaultVersion = defaultVersion;
        File baseRootDir = new File(context.getDir("qigsaw", 0), qigsawId);
        this.rootDir = new File(baseRootDir, "split_info_version");
        this.processVersionData(context);
        this.reportNewSplitInfoVersionLoaded(context);
    }

    private void reportNewSplitInfoVersionLoaded(Context context) {
        SplitUpdateReporter updateReporter;
        if (ProcessUtil.isMainProcess((Context)context) && !TextUtils.equals((CharSequence)this.currentVersion, (CharSequence)this.defaultVersion) && (updateReporter = SplitUpdateReporterManager.getUpdateReporter()) != null) {
            updateReporter.onNewSplitInfoVersionLoaded(this.currentVersion);
        }
    }

    private void processVersionData(Context context) {
        SplitInfoVersionData versionData = this.readVersionData();
        if (versionData == null) {
            SplitLog.i((String)TAG, (String)"No new split info version, just use default version.", (Object[])new Object[0]);
            this.currentVersion = this.defaultVersion;
        } else {
            String oldVersion = versionData.oldVersion;
            String newVersion = versionData.newVersion;
            if (oldVersion.equals(newVersion)) {
                SplitLog.i((String)TAG, (String)"Splits have been updated, so we use new split info version %s.", (Object[])new Object[]{newVersion});
                this.currentVersion = newVersion;
            } else if (ProcessUtil.isMainProcess((Context)context)) {
                if (this.updateVersionData(new SplitInfoVersionData(newVersion, newVersion))) {
                    this.currentVersion = newVersion;
                    ProcessUtil.killAllOtherProcess((Context)context);
                    SplitLog.i((String)TAG, (String)"Splits have been updated, start to kill other processes!", (Object[])new Object[0]);
                } else {
                    this.currentVersion = oldVersion;
                    SplitLog.w((String)TAG, (String)("Failed to update new split info version: " + newVersion), (Object[])new Object[0]);
                }
            } else {
                this.currentVersion = oldVersion;
            }
        }
    }

    private boolean updateVersionData(SplitInfoVersionData versionData) {
        try {
            SplitInfoVersionDataStorageImpl versionDataStorage = new SplitInfoVersionDataStorageImpl(this.rootDir);
            boolean result = versionDataStorage.updateVersionData(versionData);
            FileUtil.closeQuietly((Object)versionDataStorage);
            return result;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private SplitInfoVersionData readVersionData() {
        try {
            SplitInfoVersionDataStorageImpl versionDataStorage = new SplitInfoVersionDataStorageImpl(this.rootDir);
            SplitInfoVersionData versionData = versionDataStorage.readVersionData();
            FileUtil.closeQuietly((Object)versionDataStorage);
            return versionData;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean updateVersion(Context context, String newSplitInfoVersion, File newSplitInfoFile) {
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            SplitLog.w((String)TAG, (String)"Failed to make dir for split info file!", (Object[])new Object[0]);
            return false;
        }
        boolean result = false;
        String fileName = "qigsaw_" + newSplitInfoVersion + ".json";
        File dest = new File(this.rootDir, fileName);
        try {
            FileUtil.copyFile((File)newSplitInfoFile, (File)dest);
            SplitInfoVersionData versionData = new SplitInfoVersionData(this.currentVersion, newSplitInfoVersion);
            if (this.updateVersionData(versionData)) {
                SplitLog.i((String)TAG, (String)"Success to update split info version, current version %s, new version %s", (Object[])new Object[]{this.currentVersion, newSplitInfoVersion});
                result = true;
            }
            if (newSplitInfoFile.exists() && !newSplitInfoFile.delete()) {
                SplitLog.w((String)TAG, (String)("Failed to delete temp split info file: " + newSplitInfoFile.getAbsolutePath()), (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)("Failed to rename file : " + newSplitInfoFile.getAbsolutePath()), (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    @NonNull
    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    @NonNull
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }
}

