/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitDetails;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoListing;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoVersionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class SplitInfoManagerImpl
implements SplitInfoManager {
    private static final String TAG = "SplitInfoManagerImpl";
    private SplitDetails mSplitDetails;
    private SplitInfoVersionManager mVersionManager;

    SplitInfoManagerImpl() {
    }

    void attach(SplitInfoVersionManager versionManager) {
        this.mVersionManager = versionManager;
    }

    private SplitInfoVersionManager getSplitInfoVersionManager() {
        return this.mVersionManager;
    }

    private SplitDetails getSplitDetails() {
        return this.mSplitDetails;
    }

    @Override
    @Nullable
    public String getBaseAppVersionName(Context context) {
        SplitDetails details = this.getOrCreateSplitDetails(context);
        if (details != null) {
            return this.mSplitDetails.getAppVersionName();
        }
        return null;
    }

    @Override
    @Nullable
    public String getQigsawId(Context context) {
        SplitDetails details = this.getOrCreateSplitDetails(context);
        if (details != null) {
            return details.getQigsawId();
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getUpdateSplits(Context context) {
        SplitDetails details = this.getOrCreateSplitDetails(context);
        if (details != null) {
            return details.getUpdateSplits();
        }
        return null;
    }

    @Override
    public SplitInfo getSplitInfo(Context context, String splitName) {
        SplitDetails details = this.getOrCreateSplitDetails(context);
        if (details != null) {
            Collection<SplitInfo> splits = details.getSplitInfoListing().getSplitInfoMap().values();
            for (SplitInfo split : splits) {
                if (!split.getSplitName().equals(splitName)) continue;
                return split;
            }
        }
        return null;
    }

    @Override
    public Collection<SplitInfo> getAllSplitInfo(Context context) {
        SplitDetails details = this.getOrCreateSplitDetails(context);
        if (details != null) {
            return this.mSplitDetails.getSplitInfoListing().getSplitInfoMap().values();
        }
        return null;
    }

    @Override
    @Nullable
    public SplitDetails createSplitDetailsForJsonFile(@NonNull String newSplitInfoPath) {
        File newSplitInfoFile = new File(newSplitInfoPath);
        if (newSplitInfoFile.exists()) {
            return this.createSplitDetailsForNewVersion(newSplitInfoFile);
        }
        return null;
    }

    @Override
    public String getCurrentSplitInfoVersion() {
        SplitInfoVersionManager versionManager = this.getSplitInfoVersionManager();
        return versionManager.getCurrentVersion();
    }

    @Override
    public boolean updateSplitInfoVersion(Context context, String newSplitInfoVersion, File newSplitInfoFile) {
        SplitInfoVersionManager versionManager = this.getSplitInfoVersionManager();
        return versionManager.updateVersion(context, newSplitInfoVersion, newSplitInfoFile);
    }

    private SplitDetails createSplitDetailsForDefaultVersion(Context context, String defaultVersion) {
        try {
            String defaultSplitInfoFileName = "qigsaw_" + defaultVersion + ".json";
            SplitLog.i((String)TAG, (String)("Default split file name: " + defaultSplitInfoFileName), (Object[])new Object[0]);
            long currentTime = System.currentTimeMillis();
            SplitDetails details = SplitInfoManagerImpl.parseSplitContentsForDefaultVersion(context, defaultSplitInfoFileName);
            SplitLog.i((String)TAG, (String)"Cost %d mil-second to parse default split info", (Object[])new Object[]{System.currentTimeMillis() - currentTime});
            return details;
        }
        catch (Throwable e) {
            SplitLog.w((String)TAG, (String)"Failed to create default split info!", (Throwable)e);
            return null;
        }
    }

    private SplitDetails createSplitDetailsForNewVersion(File newSplitInfoFile) {
        try {
            SplitLog.i((String)TAG, (String)("Updated split file path: " + newSplitInfoFile.getAbsolutePath()), (Object[])new Object[0]);
            long currentTime = System.currentTimeMillis();
            SplitDetails details = this.parseSplitContentsForNewVersion(newSplitInfoFile);
            SplitLog.i((String)TAG, (String)"Cost %d mil-second to parse updated split info", (Object[])new Object[]{System.currentTimeMillis() - currentTime});
            return details;
        }
        catch (Throwable e) {
            SplitLog.w((String)TAG, (String)"Failed to create updated split info!", (Throwable)e);
            return null;
        }
    }

    private SplitDetails getOrCreateSplitDetails(Context context) {
        SplitInfoVersionManager versionManager = this.getSplitInfoVersionManager();
        SplitDetails details = this.getSplitDetails();
        if (details == null) {
            String currentVersion = versionManager.getCurrentVersion();
            String defaultVersion = versionManager.getDefaultVersion();
            SplitLog.i((String)TAG, (String)("currentVersion = " + currentVersion), (Object[])new Object[0]);
            SplitLog.i((String)TAG, (String)("defaultVersion = " + defaultVersion), (Object[])new Object[0]);
            if (defaultVersion.equals(currentVersion)) {
                details = this.createSplitDetailsForDefaultVersion(context, defaultVersion);
            } else {
                File updatedSplitInfoFile = new File(versionManager.getRootDir(), "qigsaw_" + currentVersion + ".json");
                details = this.createSplitDetailsForNewVersion(updatedSplitInfoFile);
            }
            if (details != null) {
                if (TextUtils.isEmpty((CharSequence)details.getQigsawId())) {
                    return null;
                }
                if (!details.verifySplitInfoListing()) {
                    return null;
                }
            }
            this.mSplitDetails = details;
        }
        return details;
    }

    private static SplitDetails parseSplitContentsForDefaultVersion(Context context, String fileName) throws IOException, JSONException {
        String content = SplitInfoManagerImpl.readInputStreamContent(SplitInfoManagerImpl.createInputStreamFromAssets(context, fileName));
        return SplitInfoManagerImpl.parseSplitsContent(content);
    }

    private SplitDetails parseSplitContentsForNewVersion(File newSplitInfoFile) throws IOException, JSONException {
        if (newSplitInfoFile != null && newSplitInfoFile.exists()) {
            return SplitInfoManagerImpl.parseSplitsContent(SplitInfoManagerImpl.readInputStreamContent(new FileInputStream(newSplitInfoFile)));
        }
        return null;
    }

    private static InputStream createInputStreamFromAssets(Context context, String fileName) {
        InputStream is = null;
        Resources resources = context.getResources();
        if (resources != null) {
            try {
                is = resources.getAssets().open(fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    private static String readInputStreamContent(InputStream is) throws IOException {
        String str;
        if (is == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder stringBuffer = new StringBuilder();
        while ((str = br.readLine()) != null) {
            stringBuffer.append(str);
        }
        FileUtil.closeQuietly((Object)is);
        FileUtil.closeQuietly((Object)br);
        return stringBuffer.toString();
    }

    private static SplitDetails parseSplitsContent(String content) throws JSONException {
        if (content == null) {
            return null;
        }
        LinkedHashMap<String, SplitInfo> splitInfoMap = new LinkedHashMap<String, SplitInfo>();
        JSONObject contentObj = new JSONObject(content);
        String qigsawId = contentObj.optString("qigsawId");
        String appVersionName = contentObj.optString("appVersionName");
        JSONArray array = contentObj.optJSONArray("splits");
        for (int i = 0; i < array.length(); ++i) {
            JSONArray libArray;
            JSONObject itemObj = array.getJSONObject(i);
            boolean builtIn = itemObj.optBoolean("builtIn");
            String splitName = itemObj.optString("splitName");
            String version = itemObj.optString("version");
            String url = itemObj.optString("url");
            String apkMd5 = itemObj.optString("md5");
            long size = itemObj.optLong("size");
            int minSdkVersion = itemObj.optInt("minSdkVersion");
            SplitInfo.LibInfo libDetail = null;
            JSONObject libDetailObj = itemObj.optJSONObject("libInfo");
            if (libDetailObj != null && (libArray = libDetailObj.optJSONArray("libs")) != null && libArray.length() > 0) {
                ArrayList<SplitInfo.LibInfo.Lib> libs = new ArrayList<SplitInfo.LibInfo.Lib>(libArray.length());
                String cpuAbi = libDetailObj.optString("abi");
                for (int j = 0; j < libArray.length(); ++j) {
                    JSONObject libObj = libArray.optJSONObject(j);
                    String name = libObj.optString("name");
                    String soMd5 = libObj.optString("md5");
                    long soSize = libObj.optLong("size");
                    SplitInfo.LibInfo.Lib lib = new SplitInfo.LibInfo.Lib(name, soMd5, soSize);
                    libs.add(lib);
                }
                libDetail = new SplitInfo.LibInfo(cpuAbi, libs);
            }
            int dexNumber = itemObj.optInt("dexNumber");
            JSONArray processes = itemObj.optJSONArray("workProcesses");
            ArrayList<String> workProcesses = null;
            if (processes != null && processes.length() > 0) {
                workProcesses = new ArrayList<String>(processes.length());
                for (int k = 0; k < processes.length(); ++k) {
                    workProcesses.add(processes.optString(k));
                }
            }
            JSONArray dependenciesArray = itemObj.optJSONArray("dependencies");
            ArrayList<String> dependencies = null;
            if (dependenciesArray != null && dependenciesArray.length() > 0) {
                dependencies = new ArrayList<String>(dependenciesArray.length());
                for (int m = 0; m < dependenciesArray.length(); ++m) {
                    dependencies.add(dependenciesArray.optString(m));
                }
            }
            SplitInfo splitInfo = new SplitInfo(splitName, appVersionName, version, url, apkMd5, size, builtIn, minSdkVersion, dexNumber, workProcesses, dependencies, libDetail);
            splitInfoMap.put(splitName, splitInfo);
        }
        JSONArray updateSplitsArray = contentObj.optJSONArray("updateSplits");
        ArrayList<String> updateSplits = null;
        if (updateSplitsArray != null && updateSplitsArray.length() > 0) {
            updateSplits = new ArrayList<String>(updateSplitsArray.length());
            for (int i = 0; i < updateSplitsArray.length(); ++i) {
                String str = updateSplitsArray.getString(i);
                updateSplits.add(str);
            }
        }
        SplitInfoListing splitInfoListing = new SplitInfoListing(splitInfoMap);
        return new SplitDetails(qigsawId, appVersionName, splitInfoListing, updateSplits);
    }
}

