/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import android.content.Context;
import androidx.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import java.util.List;

public class DefaultSplitLoadReporter
implements SplitLoadReporter {
    private static final String TAG = "SplitLoadReporter";
    protected final Context context;

    public DefaultSplitLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadOK(String processName, @NonNull List<SplitBriefInfo> loadOKSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Success to load %s in process %s cost %d ms!", (Object[])new Object[]{loadOKSplits, processName, cost});
    }

    @Override
    public void onLoadFailed(String processName, @NonNull List<SplitBriefInfo> loadOKSplits, @NonNull List<SplitLoadError> loadErrorSplits, long cost) {
        for (SplitLoadError loadError : loadErrorSplits) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)loadError.cause, (String)"Failed to load split %s in process %s cost %d ms, error code: %d!", (Object[])new Object[]{loadError.splitName, processName, cost, loadError.errorCode});
        }
    }
}

