/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import android.content.Context;
import androidx.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallReporter;
import java.util.List;

public class DefaultSplitInstallReporter
implements SplitInstallReporter {
    private static final String TAG = "SplitInstallReporter";
    protected final Context context;

    public DefaultSplitInstallReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onStartInstallOK(@NonNull List<SplitBriefInfo> installOKSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Start install %s OK, cost time %d ms.", (Object[])new Object[]{installOKSplits.toString(), cost});
    }

    @Override
    public void onStartInstallFailed(@NonNull List<SplitBriefInfo> installOKSplits, @NonNull SplitInstallError installErrorSplit, long cost) {
        SplitLog.printErrStackTrace((String)TAG, (Throwable)installErrorSplit.cause, (String)"Start to install split %s failed, cost time %d ms.", (Object[])new Object[]{installErrorSplit.splitName, cost});
    }

    @Override
    public void onDeferredInstallOK(@NonNull List<SplitBriefInfo> installOKSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Deferred install %s OK, cost time %d ms.", (Object[])new Object[]{installOKSplits.toString(), cost});
    }

    @Override
    public void onDeferredInstallFailed(@NonNull List<SplitBriefInfo> installOKSplits, @NonNull List<SplitInstallError> installErrorSplit, long cost) {
        for (SplitInstallError installError : installErrorSplit) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)installError.cause, (String)"Defer to install split %s failed with error code %d, cost time %d ms.", (Object[])new Object[]{installError.splitName, installError.errorCode, cost});
        }
    }
}

