/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@Keep
public class SplitBriefInfo {
    public static final int UNKNOWN = 0;
    public static final int FIRST_INSTALLED = 1;
    public static final int ALREADY_INSTALLED = 2;
    public final String splitName;
    public final String version;
    public final boolean builtIn;
    private int installFlag = 0;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SplitBriefInfo(@NonNull String splitName, @NonNull String version, boolean builtIn) {
        this.splitName = splitName;
        this.version = version;
        this.builtIn = builtIn;
    }

    public int getInstallFlag() {
        return this.installFlag;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setInstallFlag(int installFlag) {
        this.installFlag = installFlag;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof SplitBriefInfo)) {
            return false;
        }
        SplitBriefInfo briefInfo = (SplitBriefInfo)obj;
        if (this.splitName.equals(briefInfo.splitName) && this.version.equals(briefInfo.version) && this.builtIn == briefInfo.builtIn) {
            return true;
        }
        return super.equals(obj);
    }

    @NonNull
    public String toString() {
        return "{\"splitName\":\"" + this.splitName + "\",\"version\":\"" + this.version + "\",\"builtIn\":" + this.builtIn + "}";
    }
}

