/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import android.content.Context;
import android.support.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallReporter;
import java.util.ArrayList;
import java.util.List;

public class DefaultSplitInstallReporter
implements SplitInstallReporter {
    private static final String TAG = "SplitInstallReporter";
    protected final Context context;

    public DefaultSplitInstallReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onStartInstallOK(List<String> requestModuleNames, long cost) {
        SplitLog.i((String)TAG, (String)"Start install %s OK, cost time %d ms.", (Object[])new Object[]{requestModuleNames.toString(), cost});
    }

    @Override
    public void onStartInstallFailed(List<String> requestModuleNames, @NonNull SplitInstallError error, long cost) {
        SplitLog.w((String)TAG, (String)"Start install splits %s but %s installed failed, cost time %d ms.", (Object[])new Object[]{requestModuleNames.toString(), error.getModuleName(), cost});
        SplitLog.w((String)TAG, (String)error.toString(), (Object[])new Object[0]);
    }

    @Override
    public void onDeferredInstallOK(List<String> requestModuleNames, long cost) {
        SplitLog.i((String)TAG, (String)"Deferred install %s OK, cost time %d ms.", (Object[])new Object[]{requestModuleNames.toString(), cost});
    }

    @Override
    public void onDeferredInstallFailed(List<String> requestModuleNames, @NonNull List<SplitInstallError> errors, long cost) {
        ArrayList<String> errorModuleNames = new ArrayList<String>(errors.size());
        for (SplitInstallError error : errors) {
            errorModuleNames.add(error.getModuleName());
        }
        SplitLog.w((String)TAG, (String)"Deferred install splits %s but %s installed failed, cost time %d ms.", (Object[])new Object[]{requestModuleNames.toString(), ((Object)errorModuleNames).toString(), cost});
        SplitLog.w((String)TAG, (String)errors.toString(), (Object[])new Object[0]);
    }
}

