/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SplitLoadManager {
    protected static final String TAG = "SplitLoadManager";
    private final Context context;
    private final Set<Split> loadedSplits = Collections.newSetFromMap(new ConcurrentHashMap());
    final String currentProcessName;
    private final int splitLoadMode;

    SplitLoadManager(Context context, String currentProcessName, int splitLoadMode) {
        this.context = context;
        this.currentProcessName = currentProcessName;
        this.splitLoadMode = splitLoadMode;
    }

    public abstract void injectPathClassloader();

    public abstract void getResources(Resources var1);

    public abstract Runnable createSplitLoadTask(List<Intent> var1, @Nullable OnSplitLoadListener var2);

    public abstract void preloadInstalledSplits(Collection<String> var1);

    public abstract void loadInstalledSplits();

    public Set<String> getLoadedSplitNames() {
        HashSet<String> loadedSplitNames = new HashSet<String>(0);
        for (Split split : this.loadedSplits) {
            loadedSplitNames.add(split.splitName);
        }
        return loadedSplitNames;
    }

    int splitLoadMode() {
        return this.splitLoadMode;
    }

    Set<String> getLoadedSplitApkPaths() {
        HashSet<String> splitApkPaths = new HashSet<String>(0);
        for (Split split : this.loadedSplits) {
            File file = new File(split.splitApkPath);
            if (file.exists()) {
                splitApkPaths.add(split.splitApkPath);
                continue;
            }
            SplitLog.w((String)TAG, (String)"Split has been loaded, but its file %s is not exist!", (Object[])new Object[]{split.splitApkPath});
        }
        return splitApkPaths;
    }

    Context getContext() {
        return this.context;
    }

    final void putSplits(Collection<Split> splits) {
        this.loadedSplits.addAll(splits);
    }

    final Set<Split> getLoadedSplits() {
        return this.loadedSplits;
    }
}

