/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

final class SplitActivator {
    private final AABExtension aabExtension;
    private final Context appContext;
    private static final Map<String, Application> sSplitApplicationMap = new HashMap<String, Application>();

    SplitActivator(Context context) {
        this.appContext = context;
        this.aabExtension = AABExtension.getInstance();
    }

    Application createSplitApplication(ClassLoader classLoader, String splitName) throws SplitLoadException {
        Application app;
        try {
            app = this.aabExtension.createApplication(classLoader, splitName);
            if (app != null) {
                sSplitApplicationMap.put(splitName, app);
            }
        }
        catch (Throwable e) {
            if (this.debuggable() && !(e instanceof AABExtensionException)) {
                throw new RuntimeException(e);
            }
            throw new SplitLoadException(-24, e);
        }
        return app;
    }

    void attachSplitApplication(Application application) throws SplitLoadException {
        try {
            this.aabExtension.activeApplication(application, this.appContext);
        }
        catch (AABExtensionException e) {
            throw new SplitLoadException(-25, (Throwable)e);
        }
    }

    void invokeOnCreateForSplitApplication(Application application) throws SplitLoadException {
        if (application != null) {
            try {
                Method method = HiddenApiReflection.findMethod(Application.class, "onCreate", new Class[0]);
                method.invoke((Object)application, new Object[0]);
            }
            catch (Throwable e) {
                if (this.debuggable()) {
                    throw new RuntimeException(e);
                }
                throw new SplitLoadException(-25, e);
            }
        }
    }

    void createAndActivateSplitContentProviders(ClassLoader classLoader, String splitName) throws SplitLoadException {
        try {
            this.aabExtension.createAndActivateSplitProviders(classLoader, splitName);
        }
        catch (AABExtensionException e) {
            throw new SplitLoadException(-26, (Throwable)e);
        }
    }

    private boolean debuggable() {
        try {
            ApplicationInfo info = this.appContext.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

