/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadHandler;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadReporterManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoaderWrapper;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import java.util.List;

abstract class SplitLoadTask
implements SplitLoaderWrapper,
Runnable,
SplitLoadHandler.OnSplitLoadFinishListener {
    private static final String TAG = "SplitLoadTask";
    private final SplitLoadHandler loadHandler;
    private final OnSplitLoadListener loadListener;
    private SplitLoader splitLoader;

    SplitLoadTask(@NonNull SplitLoadManager loadManager, @NonNull List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener) {
        this.loadHandler = new SplitLoadHandler(this, loadManager, splitFileIntents);
        this.loadListener = loadListener;
    }

    Context getContext() {
        return this.loadHandler.getContext();
    }

    SplitLoader getSplitLoader() {
        if (this.splitLoader == null) {
            this.splitLoader = this.createSplitLoader();
        }
        return this.splitLoader;
    }

    @Override
    public void loadResources(String splitApkPath) throws SplitLoadException {
        this.getSplitLoader().loadResources(splitApkPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.loadHandler.loadSplitsSync(this);
        } else {
            SplitLoadTask splitLoadTask = this;
            synchronized (splitLoadTask) {
                block7: {
                    this.loadHandler.getMainHandler().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SplitLoadTask splitLoadTask = SplitLoadTask.this;
                            synchronized (splitLoadTask) {
                                SplitLoadTask.this.loadHandler.loadSplitsSync(SplitLoadTask.this);
                                SplitLoadTask.this.notifyAll();
                            }
                        }
                    });
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        SplitLog.w((String)TAG, (String)("Failed to block thread " + Thread.currentThread().getName()), (Throwable)e);
                        if (this.loadListener == null) break block7;
                        this.loadListener.onFailed(-99);
                    }
                }
            }
        }
    }

    @Override
    public void onLoadFinish(List<SplitBriefInfo> loadOKSplits, List<SplitLoadError> loadErrorSplits, String process, long totalTimeCost) {
        SplitLoadReporter loadReporter = SplitLoadReporterManager.getLoadReporter();
        if (!loadErrorSplits.isEmpty()) {
            if (this.loadListener != null) {
                int lastErrorCode = loadErrorSplits.get((int)(loadErrorSplits.size() - 1)).errorCode;
                this.loadListener.onFailed(lastErrorCode);
            }
            if (loadReporter != null) {
                loadReporter.onLoadFailed(process, loadOKSplits, loadErrorSplits, totalTimeCost);
            }
        } else {
            if (this.loadListener != null) {
                this.loadListener.onCompleted();
            }
            if (loadReporter != null) {
                loadReporter.onLoadOK(process, loadOKSplits, totalTimeCost);
            }
        }
    }
}

