/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import androidx.annotation.Keep;
import com.iqiyi.android.qigsaw.core.splitload.ClassNotFoundInterceptor;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

@Keep
final class SplitDelegateClassloader
extends PathClassLoader {
    private static BaseDexClassLoader originClassLoader;
    private ClassNotFoundInterceptor classNotFoundInterceptor;

    SplitDelegateClassloader(ClassLoader parent) {
        super("", parent);
        originClassLoader = (BaseDexClassLoader)parent;
    }

    private static void reflectPackageInfoClassloader(Context baseContext, ClassLoader reflectClassLoader) throws Exception {
        Object packageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
        if (packageInfo != null) {
            HiddenApiReflection.findField(packageInfo, "mClassLoader").set(packageInfo, reflectClassLoader);
        }
    }

    static void inject(ClassLoader originalClassloader, Context baseContext) throws Exception {
        SplitDelegateClassloader classloader = new SplitDelegateClassloader(originalClassloader);
        SplitDelegateClassloader.reflectPackageInfoClassloader(baseContext, (ClassLoader)((Object)classloader));
    }

    void setClassNotFoundInterceptor(ClassNotFoundInterceptor classNotFoundInterceptor) {
        this.classNotFoundInterceptor = classNotFoundInterceptor;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return originClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException error) {
            Class<?> result;
            if (this.classNotFoundInterceptor != null && (result = this.classNotFoundInterceptor.findClass(name)) != null) {
                return result;
            }
            throw error;
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return originClassLoader.getResources(name);
    }

    public URL getResource(String name) {
        return originClassLoader.getResource(name);
    }

    protected URL findResource(String name) {
        URL resource;
        block1: {
            SplitDexClassLoader loader;
            resource = super.findResource(name);
            if (resource != null) break block1;
            Set<SplitDexClassLoader> splitDexClassLoaders = SplitApplicationLoaders.getInstance().getValidClassLoaders();
            Iterator<SplitDexClassLoader> iterator = splitDexClassLoaders.iterator();
            while (iterator.hasNext() && (resource = (loader = iterator.next()).findResourceItself(name)) == null) {
            }
        }
        return resource;
    }

    protected Enumeration<URL> findResources(String name) {
        Enumeration<URL> resources;
        block1: {
            SplitDexClassLoader loader;
            resources = super.findResources(name);
            if (resources != null) break block1;
            Set<SplitDexClassLoader> splitDexClassLoaders = SplitApplicationLoaders.getInstance().getValidClassLoaders();
            Iterator<SplitDexClassLoader> iterator = splitDexClassLoaders.iterator();
            while (iterator.hasNext() && (resources = (loader = iterator.next()).findResourcesItself(name)) == null) {
            }
        }
        return resources;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public String findLibrary(String name) {
        String libName;
        block1: {
            SplitDexClassLoader classLoader;
            libName = originClassLoader.findLibrary(name);
            if (libName != null) break block1;
            Set<SplitDexClassLoader> splitDexClassLoaders = SplitApplicationLoaders.getInstance().getValidClassLoaders();
            Iterator<SplitDexClassLoader> iterator = splitDexClassLoaders.iterator();
            while (iterator.hasNext() && (libName = (classLoader = iterator.next()).findLibraryItself(name)) == null) {
            }
        }
        return libName;
    }
}

