/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.ClassNotFoundInterceptor;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import java.util.List;
import java.util.Set;

final class DefaultClassNotFoundInterceptor
implements ClassNotFoundInterceptor {
    private static final String TAG = "Split:ClassNotFound";
    private final Context context;
    private final ClassLoader originClassLoader;
    private final int splitLoadMode;

    DefaultClassNotFoundInterceptor(Context appContext, ClassLoader originClassLoader, int splitLoadMode) {
        this.context = appContext;
        this.originClassLoader = originClassLoader;
        this.splitLoadMode = splitLoadMode;
    }

    @Override
    public Class<?> findClass(String name) {
        if (SplitLoadManagerService.hasInstance()) {
            if (this.splitLoadMode == 1) {
                return this.onClassNotFound(name);
            }
            if (this.splitLoadMode == 2) {
                return this.onClassNotFound2(name);
            }
        }
        return null;
    }

    private Class<?> onClassNotFound(String name) {
        Class<?> ret = this.findClassInSplits(name);
        if (ret != null) {
            return ret;
        }
        Class fakeComponent = AABExtension.getInstance().getFakeComponent(name);
        if (fakeComponent != null || this.isSplitEntryFragments(name)) {
            SplitLoadManagerService.getInstance().loadInstalledSplits();
            ret = this.findClassInSplits(name);
            if (ret != null) {
                SplitLog.i((String)TAG, (String)"Class %s is found in Splits after loading all installed splits.", (Object[])new Object[]{name});
                return ret;
            }
            if (fakeComponent != null) {
                SplitLog.w((String)TAG, (String)"Split component %s is still not found after installing all installed splits, return a %s to avoid crash", (Object[])new Object[]{name, fakeComponent.getSimpleName()});
                return fakeComponent;
            }
        }
        return null;
    }

    private boolean isSplitEntryFragments(String name) {
        List splitEntryFragments;
        SplitInfoManager infoManager = SplitInfoManagerService.getInstance();
        if (infoManager != null && (splitEntryFragments = infoManager.getSplitEntryFragments(this.context)) != null && !splitEntryFragments.isEmpty()) {
            return splitEntryFragments.contains(name);
        }
        return false;
    }

    private Class<?> onClassNotFound2(String name) {
        block3: {
            Class fakeComponent = AABExtension.getInstance().getFakeComponent(name);
            if (fakeComponent != null || this.isSplitEntryFragments(name)) {
                SplitLoadManagerService.getInstance().loadInstalledSplits();
                try {
                    return this.originClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (fakeComponent == null) break block3;
                    SplitLog.w((String)TAG, (String)"Split component %s is still not found after installing all installed splits,return a %s to avoid crash", (Object[])new Object[]{name, fakeComponent.getSimpleName()});
                    return fakeComponent;
                }
            }
        }
        return null;
    }

    private Class<?> findClassInSplits(String name) {
        Set<SplitDexClassLoader> splitDexClassLoaders = SplitApplicationLoaders.getInstance().getValidClassLoaders();
        for (SplitDexClassLoader classLoader : splitDexClassLoaders) {
            try {
                Class<?> clazz = classLoader.loadClassItself(name);
                SplitLog.i((String)TAG, (String)"Class %s is found in %s ClassLoader", (Object[])new Object[]{name, classLoader.moduleName()});
                return clazz;
            }
            catch (ClassNotFoundException e) {
                SplitLog.w((String)TAG, (String)"Class %s is not found in %s ClassLoader", (Object[])new Object[]{name, classLoader.moduleName()});
            }
        }
        return null;
    }
}

