/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatDexLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatLibraryLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitUnKnownFileTypeDexLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class SplitLoaderImpl2
extends SplitLoader {
    SplitLoaderImpl2(Context context) {
        super(context);
    }

    @Override
    void loadCode2(@Nullable List<String> dexPaths, File optimizedDirectory, @Nullable File librarySearchPath) throws SplitLoadException {
        ClassLoader curCl = SplitLoader.class.getClassLoader();
        this.loadLibrary(curCl, librarySearchPath);
        this.loadDex(curCl, dexPaths, optimizedDirectory);
    }

    private void loadLibrary(ClassLoader classLoader, File librarySearchPath) throws SplitLoadException {
        if (librarySearchPath != null) {
            try {
                SplitCompatLibraryLoader.load(classLoader, librarySearchPath);
            }
            catch (Throwable cause) {
                throw new SplitLoadException(-22, cause);
            }
        }
    }

    private void loadDex(ClassLoader classLoader, List<String> dexPaths, File optimizedDirectory) throws SplitLoadException {
        if (dexPaths != null) {
            ArrayList<File> dexFiles = new ArrayList<File>(dexPaths.size());
            for (String dexPath : dexPaths) {
                dexFiles.add(new File(dexPath));
            }
            try {
                SplitCompatDexLoader.load(classLoader, optimizedDirectory, dexFiles);
                SplitUnKnownFileTypeDexLoader.loadDex(classLoader, dexPaths, optimizedDirectory);
            }
            catch (Throwable cause) {
                throw new SplitLoadException(-23, cause);
            }
        }
    }
}

