/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SplitLoadManager {
    protected static final String TAG = "SplitLoadManager";
    private final Context context;
    private final Set<Split> loadedSplits = new HashSet<Split>(0);
    private final Set<String> loadedSplitNames = new HashSet<String>(0);
    private final Set<String> loadedSplitApkPaths = new HashSet<String>(0);
    final String currentProcessName;
    final int splitLoadMode;

    SplitLoadManager(Context context, String currentProcessName, int splitLoadMode) {
        this.context = context;
        this.currentProcessName = currentProcessName;
        this.splitLoadMode = splitLoadMode;
    }

    public abstract void injectPathClassloader();

    public abstract void loadInstalledSplitsWhenAppLaunches();

    public abstract void getResources(Resources var1);

    public abstract Runnable createSplitLoadTask(List<Intent> var1, @Nullable OnSplitLoadListener var2);

    public abstract void loadInstalledSplits();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLoadedSplitNames() {
        SplitLoadManager splitLoadManager = this;
        synchronized (splitLoadManager) {
            return this.loadedSplitNames;
        }
    }

    public int splitLoadMode() {
        return this.splitLoadMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLoadedSplitApkPaths() {
        SplitLoadManager splitLoadManager = this;
        synchronized (splitLoadManager) {
            HashSet<String> loadedSplitApkPathsInsure = new HashSet<String>(this.loadedSplitApkPaths.size());
            for (String path : this.loadedSplitApkPaths) {
                File file = new File(path);
                if (file.exists() && file.isFile()) {
                    loadedSplitApkPathsInsure.add(path);
                    continue;
                }
                SplitLog.w((String)TAG, (String)"Split has been loaded, but its file %s is not exist!", (Object[])new Object[]{path});
            }
            return loadedSplitApkPathsInsure;
        }
    }

    Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putSplits(Collection<Split> splits) {
        SplitLoadManager splitLoadManager = this;
        synchronized (splitLoadManager) {
            this.loadedSplits.addAll(splits);
            for (Split split : splits) {
                this.loadedSplitNames.add(split.splitName);
                this.loadedSplitApkPaths.add(split.splitApkPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<Split> getLoadedSplits() {
        SplitLoadManager splitLoadManager = this;
        synchronized (splitLoadManager) {
            return this.loadedSplits;
        }
    }
}

