/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.support.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitApplicationLoaders;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

final class SplitDelegateClassloader
extends PathClassLoader {
    private static final String TAG = "SplitDelegateClassloader";
    private static BaseDexClassLoader originClassLoader;
    private int splitLoadMode;
    @Nullable
    static SplitDelegateClassloader sInstance;

    SplitDelegateClassloader(ClassLoader parent) {
        super("", parent);
        originClassLoader = (PathClassLoader)parent;
        sInstance = this;
    }

    private static void reflectPackageInfoClassloader(Context baseContext, ClassLoader reflectClassLoader) throws Exception {
        Object packageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
        if (packageInfo != null) {
            HiddenApiReflection.findField(packageInfo, "mClassLoader").set(packageInfo, reflectClassLoader);
        }
    }

    static void inject(ClassLoader originalClassloader, Context baseContext) throws Exception {
        SplitDelegateClassloader classloader = new SplitDelegateClassloader(originalClassloader);
        SplitDelegateClassloader.reflectPackageInfoClassloader(baseContext, (ClassLoader)((Object)classloader));
    }

    void setSplitLoadMode(int splitLoadMode) {
        this.splitLoadMode = splitLoadMode;
        SplitLog.i((String)TAG, (String)("Split load mode is : " + splitLoadMode), (Object[])new Object[0]);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return originClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException error) {
            if (SplitLoadManagerService.hasInstance()) {
                Class<?> result;
                if (this.splitLoadMode == 1) {
                    Class<?> result2 = this.onClassNotFound(name);
                    if (result2 != null) {
                        return result2;
                    }
                } else if (this.splitLoadMode == 2 && (result = this.onClassNotFound2(name)) != null) {
                    return result;
                }
            }
            throw error;
        }
    }

    private Class<?> onClassNotFound(String name) {
        Class<?> ret = this.findClassInSplits(name, null);
        if (ret != null) {
            SplitLog.i((String)TAG, (String)"Class %s is found in Splits", (Object[])new Object[]{name});
            return ret;
        }
        Class fakeComponent = AABExtension.getInstance().getFakeComponent(name);
        if (fakeComponent != null) {
            SplitLoadManagerService.getInstance().loadInstalledSplits();
            ret = this.findClassInSplits(name, null);
            if (ret != null) {
                SplitLog.i((String)TAG, (String)"Class %s is found in Splits after loading all installed splits.", (Object[])new Object[0]);
                return ret;
            }
            SplitLog.w((String)TAG, (String)"Split component %s is still not found after installing all installed splits, return a %s to avoid crash", (Object[])new Object[]{name, fakeComponent.getSimpleName()});
            return fakeComponent;
        }
        return null;
    }

    private Class<?> onClassNotFound2(String name) {
        Class fakeComponent = AABExtension.getInstance().getFakeComponent(name);
        if (fakeComponent != null) {
            SplitLoadManagerService.getInstance().loadInstalledSplits();
            try {
                return originClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                SplitLog.w((String)TAG, (String)"Split component %s is still not found after installing all installed splits,return a %s to avoid crash", (Object[])new Object[]{name, fakeComponent.getSimpleName()});
                return fakeComponent;
            }
        }
        return null;
    }

    Class<?> findClassInSplits(String name, @Nullable SplitDexClassLoader skipToFindCl) {
        Set<SplitDexClassLoader> splitDexClassLoaders = SplitApplicationLoaders.getInstance().getClassLoaders();
        for (SplitDexClassLoader classLoader : splitDexClassLoaders) {
            if (classLoader == skipToFindCl) continue;
            try {
                return classLoader.loadClassItself(name);
            }
            catch (ClassNotFoundException e) {
                SplitLog.w((String)TAG, (String)"Class %s is not found in %s ClassLoader", (Object[])new Object[]{name, classLoader.moduleName()});
            }
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return originClassLoader.getResources(name);
    }

    public URL getResource(String name) {
        return originClassLoader.getResource(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public String findLibrary(String name) {
        return originClassLoader.findLibrary(name);
    }
}

