/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;

abstract class SplitLoader {
    private static final String TAG = "SplitLoader";
    private Field mSplitResDirsField;
    private Object mPackageInfo;
    final Context context;

    SplitLoader(Context context) {
        this.context = context;
    }

    SplitDexClassLoader loadCode(String moduleNames, @Nullable List<String> dexPaths, File optimizedDirectory, @Nullable File librarySearchPath) throws SplitLoadException {
        return null;
    }

    void loadCode2(@Nullable List<String> dexPaths, File optimizedDirectory, @Nullable File librarySearchPath) throws SplitLoadException {
    }

    final void loadResources(String splitResDir) throws SplitLoadException {
        try {
            SplitCompatResourcesLoader.loadResources(this.context, this.context.getResources(), splitResDir);
            Context base = this.getBaseContext();
            try {
                this.installSplitResourceDir(base, splitResDir);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            throw new SplitLoadException(-21, throwable);
        }
    }

    private Field getFieldSplitResDirsInPackageInfo(Object packageInfo) {
        try {
            this.mSplitResDirsField = HiddenApiReflection.findField(packageInfo, "mSplitResDirs");
        }
        catch (NoSuchFieldException e) {
            SplitLog.w((String)TAG, (String)"Failed to reflect 'mSplitResDirs' field!", (Object[])new Object[0]);
        }
        return this.mSplitResDirsField;
    }

    private Context getBaseContext() {
        Context ctx = this.context;
        while (ctx instanceof ContextWrapper) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx;
    }

    private void installSplitResourceDir(Context baseContext, String splitResDir) throws Throwable {
        Field mSplitResDirsField;
        Object packageInfo = this.getPackageInfo(baseContext);
        if (packageInfo != null && (mSplitResDirsField = this.getFieldSplitResDirsInPackageInfo(packageInfo)) != null) {
            String[] splitResDirs = (String[])mSplitResDirsField.get(packageInfo);
            if (splitResDirs == null) {
                mSplitResDirsField.set(packageInfo, new String[]{splitResDir});
            } else {
                int splitSourceDirsLength = splitResDirs.length;
                String[] combined = new String[splitSourceDirsLength + 1];
                String[] expanded = new String[]{splitResDir};
                System.arraycopy(splitResDirs, 0, combined, 0, splitResDirs.length);
                System.arraycopy(expanded, 0, combined, splitResDirs.length, expanded.length);
                mSplitResDirsField.set(packageInfo, combined);
            }
        }
    }

    private Object getPackageInfo(Context baseContext) {
        if (this.mPackageInfo == null) {
            try {
                this.mPackageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
            }
            catch (Throwable e) {
                SplitLog.w((String)TAG, (String)"Failed to reflect 'mPackageInfo' instance!", (Throwable)e);
            }
        }
        return this.mPackageInfo;
    }
}

