/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatDexLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatLibraryLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class SplitLoaderImpl
extends SplitLoader {
    SplitLoaderImpl(Context context) {
        super(context);
    }

    @Override
    public void load(ClassLoader classLoader, Intent splitFileIntent) throws SplitLoadException {
        String splitApk = splitFileIntent.getStringExtra("apk");
        String splitOptDir = splitFileIntent.getStringExtra("optimized-directory");
        String splitLibPath = splitFileIntent.getStringExtra("native-libraries");
        ArrayList splitMultiDex = splitFileIntent.getStringArrayListExtra("multi-dex");
        ArrayList<String> dexPaths = new ArrayList<String>();
        dexPaths.add(splitApk);
        if (splitMultiDex != null) {
            dexPaths.addAll(splitMultiDex);
        }
        this.loadResources(splitApk);
        this.loadNativePath(classLoader, splitLibPath);
        this.loadDex(classLoader, splitOptDir, dexPaths);
    }

    @Override
    protected void loadResources(String splitResDir) throws SplitLoadException {
        try {
            SplitCompatResourcesLoader.loadResources(this.context, this.context.getResources(), splitResDir);
            Context base = this.getBaseContext();
            try {
                this.installSplitResourceDir(base, splitResDir);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            throw new SplitLoadException(-21, throwable);
        }
    }

    @Override
    protected void loadNativePath(ClassLoader classLoader, String libPath) throws SplitLoadException {
        if (!TextUtils.isEmpty((CharSequence)libPath)) {
            try {
                SplitCompatLibraryLoader.load(classLoader, new File(libPath));
            }
            catch (Throwable throwable) {
                throw new SplitLoadException(-22, throwable);
            }
        }
    }

    @Override
    protected void loadDex(ClassLoader classLoader, String optDir, List<String> dexPaths) throws SplitLoadException {
        if (!TextUtils.isEmpty((CharSequence)optDir)) {
            ArrayList<File> dexFiles = new ArrayList<File>(dexPaths.size());
            for (String dexPath : dexPaths) {
                dexFiles.add(new File(dexPath));
            }
            try {
                SplitCompatDexLoader.load(classLoader, new File(optDir), dexFiles);
            }
            catch (Throwable throwable) {
                throw new SplitLoadException(-23, throwable);
            }
        } else {
            SplitLog.i((String)"SplitLoader", (String)"No dexes are needed to load!", (Object[])new Object[0]);
        }
    }
}

