/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArraySet;
import com.iqiyi.android.qigsaw.core.common.ProcessUtil;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import dalvik.system.PathClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SplitLoadManager {
    private final Context context;
    private final Set<Split> loadedSplits = new ArraySet();
    private final Set<String> loadedSplitNames = new ArraySet();
    private final String currentProcessName;

    SplitLoadManager(Context context) {
        this.context = context;
        this.currentProcessName = ProcessUtil.getProcessName((Context)context);
    }

    public abstract void load(String[] var1);

    public abstract void getResources(Resources var1);

    public abstract Runnable createSplitLoadTask(List<Intent> var1, @Nullable OnSplitLoadListener var2, boolean var3);

    public Set<String> getLoadedSplitNames() {
        return this.loadedSplitNames;
    }

    abstract void loadInstalledSplits(boolean var1);

    abstract PathClassLoader getInjectedClassloader();

    String getCurrentProcessName() {
        return this.currentProcessName;
    }

    Context getContext() {
        return this.context;
    }

    final void putSplits(Collection<Split> splits) {
        this.loadedSplits.addAll(splits);
        for (Split split : splits) {
            this.loadedSplitNames.add(split.splitName);
        }
    }

    final Set<Split> getLoadedSplits() {
        return this.loadedSplits;
    }
}

