/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class SplitLibExtractor
implements Closeable {
    private static final String TAG = "Split:LibExtractor";
    private final File sourceApk;
    private final File libDir;
    private static final String LOCK_FILENAME = "SplitLib.lock";
    private final RandomAccessFile lockRaf;
    private final FileChannel lockChannel;
    private final FileLock cacheLock;

    SplitLibExtractor(File sourceApk, File libDir) throws IOException {
        this.sourceApk = sourceApk;
        this.libDir = libDir;
        File lockFile = new File(libDir, LOCK_FILENAME);
        this.lockRaf = new RandomAccessFile(lockFile, "rw");
        try {
            this.lockChannel = this.lockRaf.getChannel();
            try {
                SplitLog.i((String)TAG, (String)("Blocking on lock " + lockFile.getPath()), (Object[])new Object[0]);
                this.cacheLock = this.lockChannel.lock();
            }
            catch (IOException | Error | RuntimeException var5) {
                FileUtil.closeQuietly((Object)this.lockChannel);
                throw var5;
            }
            SplitLog.i((String)TAG, (String)(lockFile.getPath() + " locked"), (Object[])new Object[0]);
        }
        catch (IOException | Error | RuntimeException var6) {
            FileUtil.closeQuietly((Object)this.lockRaf);
            throw var6;
        }
    }

    List<File> load(SplitInfo.LibData libData, boolean forceReload) throws IOException {
        List<File> files;
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("SplitLibExtractor was closed");
        }
        if (!forceReload) {
            try {
                files = this.loadExistingExtractions(libData.getLibs());
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)"Failed to reload existing extracted lib files, falling back to fresh extraction", (Object[])new Object[0]);
                files = this.performExtractions(libData);
            }
        } else {
            files = this.performExtractions(libData);
        }
        SplitLog.i((String)TAG, (String)("load found " + files.size() + " lib files"), (Object[])new Object[0]);
        return files;
    }

    private List<File> performExtractions(SplitInfo.LibData libData) throws IOException {
        ZipFile sourceZip = new ZipFile(this.sourceApk);
        String libPrefix = String.format("lib/%s/", libData.getAbi());
        Enumeration<? extends ZipEntry> e = sourceZip.entries();
        ArrayList<File> libFiles = new ArrayList<File>();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (entryName.charAt(0) < 'l' || entryName.charAt(0) > 'l' || !entryName.startsWith("lib/") || !entryName.endsWith(".so") || !entryName.startsWith(libPrefix)) continue;
            String libName = entryName.substring(entryName.lastIndexOf(47) + 1);
            SplitInfo.LibData.Lib lib = this.findLib(libName, libData.getLibs());
            if (lib == null) {
                throw new IOException(String.format("Failed to find %s in split-info", libName));
            }
            File extractedLib = new File(this.libDir, libName);
            if (extractedLib.exists()) {
                if (lib.getMd5().equals(FileUtil.getMD5((File)extractedLib))) {
                    libFiles.add(extractedLib);
                    continue;
                }
                FileUtil.deleteFileSafely((File)extractedLib);
                if (extractedLib.exists()) {
                    SplitLog.w((String)TAG, (String)("Failed to delete corrupted lib file '" + extractedLib.getPath() + "'"), (Object[])new Object[0]);
                }
            }
            SplitLog.i((String)TAG, (String)("Extraction is needed for lib: " + extractedLib.getAbsolutePath()), (Object[])new Object[0]);
            int numAttempts = 0;
            boolean isExtractionSuccessful = false;
            File tempDir = SplitPathManager.require().getSplitTmpDir();
            File tmp = File.createTempFile("tmp-" + libName, "", tempDir);
            while (numAttempts < 3 && !isExtractionSuccessful) {
                ++numAttempts;
                try {
                    FileOutputStream fos = new FileOutputStream(tmp);
                    FileUtil.copyFile((InputStream)sourceZip.getInputStream(entry), (OutputStream)fos);
                    if (!tmp.renameTo(extractedLib)) {
                        SplitLog.w((String)TAG, (String)("Failed to rename \"" + tmp.getAbsolutePath() + "\" to \"" + extractedLib.getAbsolutePath() + "\""), (Object[])new Object[0]);
                    } else {
                        isExtractionSuccessful = true;
                    }
                }
                catch (IOException copyError) {
                    SplitLog.w((String)TAG, (String)("Failed to extract so :" + libName + ", attempts times : " + numAttempts), (Object[])new Object[0]);
                }
                SplitLog.i((String)TAG, (String)("Extraction " + (isExtractionSuccessful ? "succeeded" : "failed") + " '" + extractedLib.getAbsolutePath() + "': length " + extractedLib.length()), (Object[])new Object[0]);
                String libFileMd5 = FileUtil.getMD5((File)extractedLib);
                if (!lib.getMd5().equals(libFileMd5)) {
                    SplitLog.w((String)TAG, (String)"Failed to check %s md5, excepted %s but %s", (Object[])new Object[]{libName, lib.getMd5(), libFileMd5});
                    isExtractionSuccessful = false;
                }
                if (!isExtractionSuccessful) {
                    FileUtil.deleteFileSafely((File)extractedLib);
                    if (!extractedLib.exists()) continue;
                    SplitLog.w((String)TAG, (String)("Failed to delete extracted lib that has been corrupted'" + extractedLib.getPath() + "'"), (Object[])new Object[0]);
                    continue;
                }
                libFiles.add(extractedLib);
            }
            FileUtil.deleteFileSafely((File)tmp);
            if (isExtractionSuccessful) continue;
            throw new IOException("Could not create lib file " + extractedLib.getAbsolutePath() + ")");
        }
        FileUtil.closeQuietly((Object)sourceZip);
        if (libFiles.size() != libData.getLibs().size()) {
            throw new IOException("Number of extracted so files is mismatch, expected: " + libData.getLibs().size() + " ,but: " + libFiles.size());
        }
        return libFiles;
    }

    private SplitInfo.LibData.Lib findLib(String libName, List<SplitInfo.LibData.Lib> libs) {
        for (SplitInfo.LibData.Lib lib : libs) {
            if (!lib.getName().equals(libName)) continue;
            return lib;
        }
        return null;
    }

    private List<File> loadExistingExtractions(List<SplitInfo.LibData.Lib> libs) throws IOException {
        SplitLog.i((String)TAG, (String)"loading existing lib files", (Object[])new Object[0]);
        File[] files = this.libDir.listFiles();
        if (files == null || files.length <= 0) {
            throw new IOException("Missing extracted lib file '" + this.libDir.getPath() + "'");
        }
        ArrayList<File> libFiles = new ArrayList<File>(files.length);
        for (SplitInfo.LibData.Lib lib : libs) {
            boolean hasSo = false;
            for (File file : files) {
                if (!lib.getName().equals(file.getName())) continue;
                hasSo = true;
                if (!lib.getMd5().equals(FileUtil.getMD5((File)file))) {
                    throw new IOException("Invalid extracted lib : file md5 is unmatched!");
                }
                libFiles.add(file);
            }
            if (hasSo) continue;
            throw new IOException(String.format("Invalid extracted lib: file %s is not existing!", lib.getName()));
        }
        SplitLog.i((String)TAG, (String)"Existing lib files loaded", (Object[])new Object[0]);
        return libFiles;
    }

    @Override
    public void close() throws IOException {
        this.lockChannel.close();
        this.lockRaf.close();
        this.cacheLock.release();
    }
}

