/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallReporterManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallReporter;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class SplitInstallTask
implements Runnable {
    private final SplitInstaller installer;
    private final Collection<SplitInfo> needUpdateSplits;

    SplitInstallTask(SplitInstaller installer, Collection<SplitInfo> needUpdateSplits) {
        this.installer = installer;
        this.needUpdateSplits = needUpdateSplits;
    }

    abstract boolean isStartInstallOperation();

    @Override
    public final void run() {
        this.onPreInstall();
        long totalInstallStart = System.currentTimeMillis();
        boolean installCompleted = true;
        boolean isStartInstall = this.isStartInstallOperation();
        ArrayList<SplitInstaller.InstallResult> installResults = new ArrayList<SplitInstaller.InstallResult>();
        ArrayList<SplitBriefInfo> installOKSplits = new ArrayList<SplitBriefInfo>(this.needUpdateSplits.size());
        ArrayList<SplitInstallError> installErrorSplits = new ArrayList<SplitInstallError>();
        for (SplitInfo info : this.needUpdateSplits) {
            SplitBriefInfo briefInfo = new SplitBriefInfo(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn());
            try {
                long installStart = System.currentTimeMillis();
                SplitInstaller.InstallResult installResult = this.installer.install(isStartInstall, info);
                int installFlag = installResult.firstInstalled ? 1 : 2;
                installOKSplits.add(briefInfo.setInstallFlag(installFlag).setTimeCost(System.currentTimeMillis() - installStart));
                installResults.add(installResult);
            }
            catch (SplitInstaller.InstallException error) {
                installCompleted = false;
                installErrorSplits.add(new SplitInstallError(briefInfo, error.getErrorCode(), error.getCause()));
                if (!isStartInstall) continue;
                break;
            }
        }
        SplitInstallReporter installReporter = SplitInstallReporterManager.getInstallReporter();
        if (installCompleted) {
            this.onInstallCompleted(installResults);
            if (installReporter != null) {
                if (isStartInstall) {
                    installReporter.onStartInstallOK(installOKSplits, System.currentTimeMillis() - totalInstallStart);
                } else {
                    installReporter.onDeferredInstallOK(installOKSplits, System.currentTimeMillis() - totalInstallStart);
                }
            }
        } else {
            this.onInstallFailed(installErrorSplits);
            if (installReporter != null) {
                if (isStartInstall) {
                    installReporter.onStartInstallFailed(installOKSplits, (SplitInstallError)installErrorSplits.get(0), System.currentTimeMillis() - totalInstallStart);
                } else {
                    installReporter.onDeferredInstallFailed(installOKSplits, installErrorSplits, System.currentTimeMillis() - totalInstallStart);
                }
            }
        }
    }

    protected void onPreInstall() {
    }

    void onInstallCompleted(List<SplitInstaller.InstallResult> installResults) {
    }

    void onInstallFailed(List<SplitInstallError> errors) {
    }
}

