/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitAABInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitdownload.DownloadCallback;
import com.iqiyi.android.qigsaw.core.splitdownload.DownloadRequest;
import com.iqiyi.android.qigsaw.core.splitdownload.Downloader;
import com.iqiyi.android.qigsaw.core.splitinstall.DeferredDownloadCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitDownloadPreprocessor;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallerImpl;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitPendingUninstallManager;
import com.iqiyi.android.qigsaw.core.splitinstall.StartDownloadCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.SplitInstallSupervisor;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class SplitInstallSupervisorImpl
extends SplitInstallSupervisor {
    private static final String TAG = "Split:SplitInstallSupervisorImpl";
    private final Context appContext;
    private final SplitInstallSessionManager sessionManager;
    private final Downloader userDownloader;
    private final long downloadSizeThresholdValue;
    private final Set<String> installedSplitForAAB;
    private final Class<?> obtainUserConfirmationActivityClass;
    private final SplitInstaller splitInstaller;
    private final boolean verifySignature;
    private final List<String> dynamicFeatures;

    SplitInstallSupervisorImpl(Context appContext, SplitInstallSessionManager sessionManager, Downloader userDownloader, Class<? extends Activity> obtainUserConfirmationActivityClass, boolean verifySignature) {
        this.appContext = appContext;
        this.sessionManager = sessionManager;
        this.userDownloader = userDownloader;
        long downloadSizeThreshold = userDownloader.getDownloadSizeThresholdWhenUsingMobileData();
        this.downloadSizeThresholdValue = downloadSizeThreshold < 0L ? Long.MAX_VALUE : downloadSizeThreshold;
        this.installedSplitForAAB = new SplitAABInfoProvider(this.appContext).getInstalledSplitsForAAB();
        this.obtainUserConfirmationActivityClass = obtainUserConfirmationActivityClass;
        this.splitInstaller = new SplitInstallerImpl(appContext, verifySignature);
        this.verifySignature = verifySignature;
        String[] dynamicFeaturesArray = SplitBaseInfoProvider.getDynamicFeatures();
        List<String> list = this.dynamicFeatures = dynamicFeaturesArray == null ? null : Arrays.asList(dynamicFeaturesArray);
        if (this.dynamicFeatures == null) {
            SplitLog.w((String)TAG, (String)"Can't read dynamicFeatures from SplitBaseInfoProvider", (Object[])new Object[0]);
        }
    }

    @Override
    public void startInstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        List<String> moduleNameList = SplitInstallSupervisorImpl.unBundleModuleNames(moduleNames);
        int errorCode = this.onPreInstallSplits(moduleNameList);
        if (errorCode != 0) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(errorCode));
        } else {
            List<SplitInfo> needInstallSplits = this.getNeed2BeInstalledSplits(moduleNameList);
            if (!this.isAllSplitsBuiltIn(needInstallSplits) && !SplitInstallSupervisorImpl.isNetworkAvailable(this.appContext)) {
                callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-6));
                return;
            }
            this.startDownloadSplits(moduleNameList, needInstallSplits, callback);
        }
    }

    @Override
    public void deferredInstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        List<String> moduleNameList = SplitInstallSupervisorImpl.unBundleModuleNames(moduleNames);
        int errorCode = this.onPreInstallSplits(moduleNameList);
        if (errorCode == 0) {
            if (!this.getInstalledSplitForAAB().isEmpty()) {
                if (this.getInstalledSplitForAAB().containsAll(moduleNameList)) {
                    callback.onDeferredInstall(null);
                }
            } else {
                List<SplitInfo> needInstallSplits = this.getNeed2BeInstalledSplits(moduleNameList);
                this.deferredDownloadSplits(needInstallSplits, callback);
            }
        } else {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(errorCode));
        }
    }

    @Override
    public void deferredUninstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        if (!this.getInstalledSplitForAAB().isEmpty()) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-98));
            return;
        }
        List<String> moduleNameList = SplitInstallSupervisorImpl.unBundleModuleNames(moduleNames);
        int errorCode = this.checkInternalErrorCode();
        if (errorCode != 0) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(errorCode));
            return;
        }
        if (this.isRequestInvalid(moduleNameList)) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-3));
            return;
        }
        SplitPendingUninstallManager uninstallInfoManager = new SplitPendingUninstallManager();
        boolean result = uninstallInfoManager.recordPendingUninstallSplits(moduleNameList);
        if (result) {
            SplitLog.w((String)TAG, (String)"Succeed to record pending uninstall splits %s!", (Object[])new Object[]{moduleNameList.toString()});
            callback.onDeferredUninstall(null);
        } else {
            SplitLog.w((String)TAG, (String)"Failed to record pending uninstall splits!", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-100));
        }
    }

    @Override
    public void cancelInstall(int sessionId, SplitInstallSupervisor.Callback callback) {
        SplitLog.i((String)TAG, (String)"start to cancel session id %d installation", (Object[])new Object[]{sessionId});
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState == null) {
            SplitLog.i((String)TAG, (String)"Session id is not found!", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-4));
            return;
        }
        if (sessionState.status() == 1 || sessionState.status() == 2) {
            boolean ret = this.userDownloader.cancelDownloadSync(sessionId);
            SplitLog.d((String)TAG, (String)("result of cancel request : " + ret), (Object[])new Object[0]);
            if (ret) {
                callback.onCancelInstall(sessionId, null);
            } else {
                callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-3));
            }
        } else {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-3));
        }
    }

    @Override
    public void getSessionState(int sessionId, SplitInstallSupervisor.Callback callback) {
        SplitInstallInternalSessionState sessionStateVariant = this.sessionManager.getSessionState(sessionId);
        if (sessionStateVariant == null) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-4));
            return;
        }
        callback.onGetSession(sessionId, SplitInstallInternalSessionState.transform2Bundle(sessionStateVariant));
    }

    @Override
    public void getSessionStates(SplitInstallSupervisor.Callback callback) {
        List<SplitInstallInternalSessionState> sessionStateVariantList = this.sessionManager.getSessionStates();
        if (sessionStateVariantList.isEmpty()) {
            callback.onGetSessionStates(Collections.emptyList());
        } else {
            ArrayList<Bundle> sessionStates = new ArrayList<Bundle>(0);
            for (SplitInstallInternalSessionState sessionStateVariant : sessionStateVariantList) {
                sessionStates.add(SplitInstallInternalSessionState.transform2Bundle(sessionStateVariant));
            }
            callback.onGetSessionStates(sessionStates);
        }
    }

    @Override
    public boolean continueInstallWithUserConfirmation(int sessionId) {
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState != null) {
            StartDownloadCallback downloadCallback = new StartDownloadCallback(this.splitInstaller, sessionId, this.sessionManager, sessionState.needInstalledSplits);
            this.sessionManager.changeSessionState(sessionId, 1);
            this.sessionManager.emitSessionState(sessionState);
            this.userDownloader.startDownload(sessionState.sessionId(), sessionState.downloadRequests, (DownloadCallback)downloadCallback);
            return true;
        }
        return false;
    }

    @Override
    public boolean cancelInstallWithoutUserConfirmation(int sessionId) {
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState != null) {
            this.sessionManager.changeSessionState(sessionState.sessionId(), 7);
            this.sessionManager.emitSessionState(sessionState);
            return true;
        }
        return false;
    }

    private boolean isAllSplitsBuiltIn(List<SplitInfo> needInstallSplits) {
        for (SplitInfo info : needInstallSplits) {
            if (info.isBuiltIn()) continue;
            return false;
        }
        return true;
    }

    private int onPreInstallSplits(List<String> moduleNames) {
        if (!this.getInstalledSplitForAAB().isEmpty()) {
            if (!this.getInstalledSplitForAAB().containsAll(moduleNames)) {
                return -3;
            }
        } else {
            int errorCode = this.checkInternalErrorCode();
            if (errorCode == 0) {
                errorCode = this.checkRequestErrorCode(moduleNames);
            }
            return errorCode;
        }
        return 0;
    }

    private int checkRequestErrorCode(List<String> moduleNames) {
        if (this.isRequestInvalid(moduleNames)) {
            return -3;
        }
        if (!this.isModuleAvailable(moduleNames)) {
            return -2;
        }
        return 0;
    }

    private int checkInternalErrorCode() {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager == null) {
            SplitLog.w((String)TAG, (String)"Failed to fetch SplitInfoManager instance!", (Object[])new Object[0]);
            return -100;
        }
        Collection allSplits = manager.getAllSplitInfo(this.appContext);
        if (allSplits == null || allSplits.isEmpty()) {
            SplitLog.w((String)TAG, (String)"Failed to parse json file of split info!", (Object[])new Object[0]);
            return -100;
        }
        String baseAppVersionName = manager.getBaseAppVersionName(this.appContext);
        String versionName = SplitBaseInfoProvider.getVersionName();
        if (TextUtils.isEmpty((CharSequence)baseAppVersionName) || !baseAppVersionName.equals(versionName)) {
            SplitLog.w((String)TAG, (String)"Failed to match base app version-name excepted base app version %s but %s!", (Object[])new Object[]{versionName, baseAppVersionName});
            return -100;
        }
        String qigsawId = manager.getQigsawId(this.appContext);
        String baseAppQigsawId = SplitBaseInfoProvider.getQigsawId();
        if (TextUtils.isEmpty((CharSequence)qigsawId) || !qigsawId.equals(baseAppQigsawId)) {
            SplitLog.w((String)TAG, (String)"Failed to match base app qigsaw-version excepted %s but %s!", (Object[])new Object[]{baseAppQigsawId, qigsawId});
            return -100;
        }
        return 0;
    }

    private Set<String> getInstalledSplitForAAB() {
        return this.installedSplitForAAB;
    }

    private List<SplitInfo> getNeed2BeInstalledSplits(List<String> moduleNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        List needInstallSplitInfos = manager.getSplitInfos(this.appContext, moduleNames);
        HashSet dependenciesSplits = new HashSet(0);
        for (SplitInfo info : needInstallSplitInfos) {
            if (info.getDependencies() == null) continue;
            dependenciesSplits.addAll(info.getDependencies());
        }
        if (!dependenciesSplits.isEmpty()) {
            dependenciesSplits.removeAll(moduleNames);
            SplitLog.i((String)TAG, (String)"Add dependencies %s automatically for install splits %s!", (Object[])new Object[]{((Object)dependenciesSplits).toString(), moduleNames.toString()});
            List dependenciesSplitInfos = manager.getSplitInfos(this.appContext, dependenciesSplits);
            dependenciesSplitInfos.addAll(needInstallSplitInfos);
            return dependenciesSplitInfos;
        }
        return needInstallSplitInfos;
    }

    private void deferredDownloadSplits(List<SplitInfo> needInstallSplits, SplitInstallSupervisor.Callback callback) {
        try {
            long[] result = this.onPreDownloadSplits(needInstallSplits);
            callback.onDeferredInstall(null);
            long realTotalBytesNeedToDownload = result[1];
            int sessionId = SplitInstallSupervisorImpl.createSessionId(needInstallSplits);
            SplitLog.d((String)TAG, (String)("DeferredInstall session id: " + sessionId), (Object[])new Object[0]);
            DeferredDownloadCallback downloadCallback = new DeferredDownloadCallback(this.splitInstaller, needInstallSplits);
            if (realTotalBytesNeedToDownload == 0L) {
                SplitLog.d((String)TAG, (String)"Splits have been downloaded, install them directly!", (Object[])new Object[0]);
                downloadCallback.onCompleted();
            } else {
                boolean usingMobileDataPermitted = realTotalBytesNeedToDownload < this.downloadSizeThresholdValue && !this.userDownloader.isDeferredDownloadOnlyWhenUsingWifiData();
                this.userDownloader.deferredDownload(sessionId, this.createDownloadRequests(needInstallSplits), (DownloadCallback)downloadCallback, usingMobileDataPermitted);
            }
        }
        catch (IOException e) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-99));
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to copy builtin split apks(%s)", (Object[])new Object[]{"onDeferredInstall"});
        }
    }

    private void startDownloadSplits(List<String> moduleNames, List<SplitInfo> needInstallSplits, SplitInstallSupervisor.Callback callback) {
        boolean needUserConfirmation;
        if (this.sessionManager.isActiveSessionsLimitExceeded()) {
            SplitLog.w((String)TAG, (String)"Start install request error code: ACTIVE_SESSIONS_LIMIT_EXCEEDED", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-1));
            return;
        }
        int sessionId = SplitInstallSupervisorImpl.createSessionId(needInstallSplits);
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        boolean bl = needUserConfirmation = sessionState != null && sessionState.status() == 8;
        if (!needUserConfirmation && this.sessionManager.isIncompatibleWithExistingSession(moduleNames)) {
            SplitLog.w((String)TAG, (String)"Start install request error code: INCOMPATIBLE_WITH_EXISTING_SESSION", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-8));
            return;
        }
        SplitLog.d((String)TAG, (String)("startInstall session id: " + sessionId), (Object[])new Object[0]);
        try {
            List<DownloadRequest> downloadRequests = this.createDownloadRequests(needInstallSplits);
            if (sessionState == null) {
                sessionState = new SplitInstallInternalSessionState(sessionId, moduleNames, needInstallSplits, downloadRequests);
            }
            long[] result = this.onPreDownloadSplits(needInstallSplits);
            callback.onStartInstall(sessionId, null);
            this.sessionManager.setSessionState(sessionId, sessionState);
            long totalBytesToDownload = result[0];
            long realTotalBytesNeedToDownload = result[1];
            SplitLog.d((String)TAG, (String)"totalBytesToDownload: %d, realTotalBytesNeedToDownload: %d ", (Object[])new Object[]{totalBytesToDownload, realTotalBytesNeedToDownload});
            sessionState.setTotalBytesToDownload(totalBytesToDownload);
            StartDownloadCallback downloadCallback = new StartDownloadCallback(this.splitInstaller, sessionId, this.sessionManager, needInstallSplits);
            if (realTotalBytesNeedToDownload <= 0L) {
                SplitLog.d((String)TAG, (String)"Splits have been downloaded, install them directly!", (Object[])new Object[0]);
                downloadCallback.onCompleted();
            } else {
                if (SplitInstallSupervisorImpl.isMobileAvailable(this.appContext) && realTotalBytesNeedToDownload > this.downloadSizeThresholdValue) {
                    this.startUserConfirmationActivity(sessionState, realTotalBytesNeedToDownload, downloadRequests);
                    return;
                }
                this.sessionManager.changeSessionState(sessionId, 1);
                this.sessionManager.emitSessionState(sessionState);
                this.userDownloader.startDownload(sessionId, downloadRequests, (DownloadCallback)downloadCallback);
            }
        }
        catch (IOException e) {
            SplitLog.w((String)TAG, (String)"Failed to copy internal splits", (Throwable)e);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-99));
        }
    }

    private void startUserConfirmationActivity(SplitInstallInternalSessionState sessionState, long realTotalBytesNeedToDownload, List<DownloadRequest> requests) {
        Intent intent = new Intent();
        intent.putExtra("sessionId", sessionState.sessionId());
        intent.putParcelableArrayListExtra("downloadRequests", (ArrayList)requests);
        intent.putExtra("realTotalBytesNeedToDownload", realTotalBytesNeedToDownload);
        intent.putStringArrayListExtra("moduleNames", (ArrayList)sessionState.moduleNames());
        intent.setClass(this.appContext, this.obtainUserConfirmationActivityClass);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)0, (Intent)intent, (int)0x8000000);
        sessionState.setUserConfirmationIntent(pendingIntent);
        this.sessionManager.changeSessionState(sessionState.sessionId(), 8);
        this.sessionManager.emitSessionState(sessionState);
    }

    private boolean isRequestInvalid(List<String> moduleNames) {
        return moduleNames == null || moduleNames.isEmpty() || this.dynamicFeatures == null || !this.dynamicFeatures.containsAll(moduleNames);
    }

    private boolean isModuleAvailable(List<String> moduleNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        Collection splitInfoList = manager.getAllSplitInfo(this.appContext);
        for (String moduleName : moduleNames) {
            for (SplitInfo info : splitInfoList) {
                if (!info.getSplitName().equals(moduleName) || this.checkSplitInfo(info)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkSplitInfo(SplitInfo info) {
        return this.isCPUArchMatched(info) && this.isMinSdkVersionMatched(info);
    }

    private boolean isMinSdkVersionMatched(SplitInfo splitInfo) {
        return splitInfo.getMinSdkVersion() <= Build.VERSION.SDK_INT;
    }

    private boolean isCPUArchMatched(SplitInfo splitInfo) {
        try {
            splitInfo.getPrimaryLibData(this.appContext);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private List<DownloadRequest> createDownloadRequests(Collection<SplitInfo> splitInfoList) throws IOException {
        ArrayList<DownloadRequest> requests = new ArrayList<DownloadRequest>(splitInfoList.size());
        for (SplitInfo splitInfo : splitInfoList) {
            List apkDataList = splitInfo.getApkDataList(this.appContext);
            for (SplitInfo.ApkData apkData : apkDataList) {
                File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
                DownloadRequest request = DownloadRequest.newBuilder().url(apkData.getUrl()).fileDir(splitDir.getAbsolutePath()).fileName(splitInfo.getSplitName() + "-" + apkData.getAbi() + ".apk").fileMD5(apkData.getMd5()).moduleName(splitInfo.getSplitName()).build();
                requests.add(request);
            }
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] onPreDownloadSplits(Collection<SplitInfo> splitInfoList) throws IOException {
        long totalBytesToDownload = 0L;
        long realTotalBytesNeedToDownload = 0L;
        for (SplitInfo splitInfo : splitInfoList) {
            List<SplitDownloadPreprocessor.SplitFile> splitApkList;
            File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
            SplitDownloadPreprocessor processor = new SplitDownloadPreprocessor(splitDir);
            try {
                splitApkList = processor.load(this.appContext, splitInfo, this.verifySignature);
            }
            finally {
                FileUtil.closeQuietly((Object)processor);
            }
            totalBytesToDownload += splitInfo.getApkTotalSize(this.appContext);
            for (SplitDownloadPreprocessor.SplitFile splitApk : splitApkList) {
                if (splitApk.exists()) continue;
                realTotalBytesNeedToDownload += splitApk.realSize;
            }
        }
        return new long[]{totalBytesToDownload, realTotalBytesNeedToDownload};
    }
}

