/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.SparseArray;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import java.util.ArrayList;
import java.util.List;

final class SplitInstallSessionManagerImpl
implements SplitInstallSessionManager {
    private final SparseArray<SplitInstallInternalSessionState> mActiveSessionStates = new SparseArray();
    private final Context mContext;
    private final String mPackageName;
    private final Object mLock = new Object();

    SplitInstallSessionManagerImpl(Context context) {
        this.mContext = context;
        this.mPackageName = context.getPackageName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionState(int sessionId, SplitInstallInternalSessionState sessionState) {
        Object object = this.mLock;
        synchronized (object) {
            if (sessionId != 0 && this.mActiveSessionStates.get(sessionId) == null) {
                this.mActiveSessionStates.put(sessionId, (Object)sessionState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSessionState(int sessionId, int status) {
        Object object = this.mLock;
        synchronized (object) {
            SplitInstallInternalSessionState sessionState = (SplitInstallInternalSessionState)this.mActiveSessionStates.get(sessionId);
            if (sessionState != null) {
                sessionState.setStatus(status);
                if (status == 7 || status == 6 || status == 10) {
                    this.removeSessionState(sessionId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionState(int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            if (sessionId != 0) {
                this.mActiveSessionStates.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveSessionsLimitExceeded() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mActiveSessionStates.size(); ++i) {
                SplitInstallInternalSessionState state = (SplitInstallInternalSessionState)this.mActiveSessionStates.valueAt(i);
                if (state.status() != 2) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SplitInstallInternalSessionState getSessionState(int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            return (SplitInstallInternalSessionState)this.mActiveSessionStates.get(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SplitInstallInternalSessionState> getSessionStates() {
        Object object = this.mLock;
        synchronized (object) {
            return SplitInstallSessionManagerImpl.asList(this.mActiveSessionStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncompatibleWithExistingSession(List<String> moduleNames) {
        Object object = this.mLock;
        synchronized (object) {
            boolean incompatibleWithExistingSession = false;
            List<SplitInstallInternalSessionState> sessionStates = this.getSessionStates();
            block3: for (int i = 0; i < sessionStates.size(); ++i) {
                SplitInstallInternalSessionState sessionState = sessionStates.get(i);
                for (String moduleName : moduleNames) {
                    if (sessionState.moduleNames().contains(moduleName)) {
                        incompatibleWithExistingSession = true;
                        continue block3;
                    }
                    if (!incompatibleWithExistingSession) continue;
                    continue block3;
                }
            }
            return incompatibleWithExistingSession;
        }
    }

    @Override
    public void emitSessionState(SplitInstallInternalSessionState sessionState) {
        Bundle bundle = SplitInstallInternalSessionState.transform2Bundle(sessionState);
        Intent intent = new Intent();
        intent.putExtra("session_state", bundle);
        intent.setPackage(this.mPackageName);
        intent.setAction("com.iqiyi.android.play.core.splitinstall.receiver.SplitInstallUpdateIntentService");
        this.mContext.sendBroadcast(intent);
    }

    private static <C> List<C> asList(SparseArray<C> sparseArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            arrayList.add(sparseArray.valueAt(i));
        }
        return arrayList;
    }
}

