/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.File;
import java.util.List;

abstract class SplitInstaller {
    SplitInstaller() {
    }

    public abstract InstallResult install(boolean var1, SplitInfo var2) throws InstallException;

    protected abstract void verifySignature(File var1) throws InstallException;

    protected abstract void checkSplitMD5(File var1, String var2) throws InstallException;

    protected abstract List<String> extractMultiDex(SplitInfo var1, File var2) throws InstallException;

    protected abstract void extractLib(SplitInfo var1, File var2) throws InstallException;

    protected abstract boolean createInstalledMark(File var1) throws InstallException;

    protected abstract boolean createInstalledMarkLock(File var1, File var2) throws InstallException;

    static final class InstallException
    extends Exception {
        private final int errorCode;

        InstallException(int errorCode, Throwable e) {
            super(new StringBuilder(32).append("Split Install Error: ").append(errorCode).toString(), e);
            this.errorCode = errorCode;
        }

        int getErrorCode() {
            return this.errorCode;
        }
    }

    static class InstallResult {
        final String splitName;
        final File apkFile;
        final List<String> addedDexPaths;
        final boolean firstInstalled;

        InstallResult(@NonNull String splitName, @NonNull File apkFile, @Nullable List<String> addedDexPaths, boolean firstInstalled) {
            this.splitName = splitName;
            this.apkFile = apkFile;
            this.addedDexPaths = addedDexPaths;
            this.firstInstalled = firstInstalled;
        }
    }
}

