/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.OEMCompat;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SignatureValidator;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitLibExtractor;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitMultiDexExtractor;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SplitInstallerImpl
extends SplitInstaller {
    private static final boolean IS_VM_MULTIDEX_CAPABLE = SplitInstallerImpl.isVMMultiDexCapable(System.getProperty("java.vm.version"));
    private static final String TAG = "SplitInstallerImpl";
    private final Context appContext;
    private final boolean verifySignature;

    SplitInstallerImpl(Context context, boolean verifySignature) {
        this.appContext = context;
        this.verifySignature = verifySignature;
    }

    @Override
    public SplitInstaller.InstallResult install(boolean startInstall, SplitInfo info) throws SplitInstaller.InstallException {
        File splitDir = SplitPathManager.require().getSplitDir(info);
        File sourceApk = info.isBuiltIn() && info.getUrl().startsWith("native://") ? new File(this.appContext.getApplicationInfo().nativeLibraryDir, System.mapLibraryName("split_" + info.getSplitName())) : new File(splitDir, info.getSplitName() + ".apk");
        if (!FileUtil.isLegalFile((File)sourceApk)) {
            throw new SplitInstaller.InstallException(-11, (Throwable)new FileNotFoundException("Split apk " + sourceApk.getAbsolutePath() + " is illegal!"));
        }
        if (this.verifySignature) {
            SplitLog.d((String)TAG, (String)"Need to verify split %s signature!", (Object[])new Object[]{sourceApk.getAbsolutePath()});
            this.verifySignature(sourceApk);
        }
        this.checkSplitMD5(sourceApk, info.getMd5());
        File splitLibDir = null;
        if (this.isLibExtractNeeded(info)) {
            this.extractLib(info, sourceApk);
            splitLibDir = SplitPathManager.require().getSplitLibDir(info);
        }
        ArrayList<String> addedDexPaths = null;
        if (info.hasDex()) {
            addedDexPaths = new ArrayList<String>();
            addedDexPaths.add(sourceApk.getAbsolutePath());
            if (!this.isVMMultiDexCapable() && this.isMultiDexExtractNeeded(info)) {
                addedDexPaths.addAll(this.extractMultiDex(info, sourceApk));
            }
        }
        File markFile = SplitPathManager.require().getSplitMarkFile(info);
        if (addedDexPaths != null) {
            String librarySearchPath;
            String dexPath = TextUtils.join((CharSequence)File.pathSeparator, addedDexPaths);
            File optimizedDirectory = SplitPathManager.require().getSplitOptDir(info);
            String string = librarySearchPath = splitLibDir == null ? null : splitLibDir.getAbsolutePath();
            if (!markFile.exists()) {
                try {
                    new DexClassLoader(dexPath, optimizedDirectory.getAbsolutePath(), librarySearchPath, SplitInstallerImpl.class.getClassLoader());
                }
                catch (Throwable error) {
                    throw new SplitInstaller.InstallException(-17, error);
                }
            }
            if (OEMCompat.shouldCheckOatFileInCurrentSys()) {
                SplitLog.v((String)TAG, (String)("Start to check oat file, current api level is " + Build.VERSION.SDK_INT), (Object[])new Object[0]);
                boolean specialManufacturer = OEMCompat.isSpecialManufacturer();
                File oatFile = OEMCompat.getOatFilePath((File)sourceApk, (File)optimizedDirectory);
                if (FileUtil.isLegalFile((File)oatFile)) {
                    boolean checkResult = OEMCompat.checkOatFile((File)oatFile);
                    SplitLog.v((String)TAG, (String)("Result of oat file %s is " + checkResult), (Object[])new Object[]{oatFile.getAbsoluteFile()});
                    if (!checkResult) {
                        SplitLog.w((String)TAG, (String)("Failed to check oat file " + oatFile.getAbsolutePath()), (Object[])new Object[0]);
                        if (specialManufacturer) {
                            File lockFile = SplitPathManager.require().getSplitSpecialLockFile(info);
                            try {
                                FileUtil.deleteFileSafelyLock((File)oatFile, (File)lockFile);
                            }
                            catch (IOException error) {
                                SplitLog.w((String)TAG, (String)("Failed to delete corrupted oat file " + oatFile.exists()), (Object[])new Object[0]);
                            }
                        } else {
                            FileUtil.deleteFileSafely((File)oatFile);
                        }
                        throw new SplitInstaller.InstallException(-18, (Throwable)new FileNotFoundException("System generate split " + info.getSplitName() + " oat file failed!"));
                    }
                } else if (specialManufacturer) {
                    SplitLog.v((String)TAG, (String)"Oat file %s is not exist in vivo & oppo, system would use interpreter mode.", (Object[])new Object[]{oatFile.getAbsoluteFile()});
                    File specialMarkFile = SplitPathManager.require().getSplitSpecialMarkFile(info);
                    if (!markFile.exists() && !specialMarkFile.exists()) {
                        File lockFile = SplitPathManager.require().getSplitSpecialLockFile(info);
                        boolean firstInstalled = this.createInstalledMarkLock(specialMarkFile, lockFile);
                        return new SplitInstaller.InstallResult(info.getSplitName(), sourceApk, addedDexPaths, firstInstalled);
                    }
                }
            }
        }
        boolean firstInstalled = this.createInstalledMark(markFile);
        return new SplitInstaller.InstallResult(info.getSplitName(), sourceApk, addedDexPaths, firstInstalled);
    }

    @Override
    protected void verifySignature(File splitApk) throws SplitInstaller.InstallException {
        if (!SignatureValidator.validateSplit(this.appContext, splitApk)) {
            this.deleteCorruptedFiles(Collections.singletonList(splitApk));
            throw new SplitInstaller.InstallException(-12, (Throwable)new SignatureException("Failed to check split apk " + splitApk.getAbsolutePath() + " signature!"));
        }
    }

    @Override
    protected void checkSplitMD5(File splitApk, String splitApkMd5) throws SplitInstaller.InstallException {
        String curMd5 = FileUtil.getMD5((File)splitApk);
        if (!splitApkMd5.equals(curMd5)) {
            this.deleteCorruptedFiles(Collections.singletonList(splitApk));
            throw new SplitInstaller.InstallException(-13, (Throwable)new IOException("Failed to check split apk md5, expect " + splitApkMd5 + " but " + curMd5));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<String> extractMultiDex(SplitInfo info, File splitApk) throws SplitInstaller.InstallException {
        SplitLog.w((String)TAG, (String)"VM do not support multi-dex, but split %s has multi dex files, so we need install other dex files manually", (Object[])new Object[]{splitApk.getName()});
        File codeCacheDir = SplitPathManager.require().getSplitCodeCacheDir(info);
        String prefsKeyPrefix = info.getSplitName() + "@" + SplitBaseInfoProvider.getVersionName() + "@" + info.getSplitVersion();
        try {
            SplitMultiDexExtractor extractor = new SplitMultiDexExtractor(splitApk, codeCacheDir);
            try {
                List<? extends File> dexFiles = extractor.load(this.appContext, prefsKeyPrefix, false);
                ArrayList<String> dexPaths = new ArrayList<String>(dexFiles.size());
                for (File file : dexFiles) {
                    dexPaths.add(file.getAbsolutePath());
                }
                SplitLog.w((String)TAG, (String)"Succeed to load or extract dex files", (Object[])new Object[]{dexFiles.toString()});
                ArrayList<String> arrayList = dexPaths;
                return arrayList;
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)"Failed to load or extract dex files", (Throwable)e);
                throw new SplitInstaller.InstallException(-14, (Throwable)e);
            }
            finally {
                FileUtil.closeQuietly((Object)extractor);
            }
        }
        catch (IOException ioError) {
            throw new SplitInstaller.InstallException(-14, (Throwable)ioError);
        }
    }

    @Override
    protected void extractLib(SplitInfo info, File sourceApk) throws SplitInstaller.InstallException {
        try {
            File splitLibDir = SplitPathManager.require().getSplitLibDir(info);
            SplitLibExtractor extractor = new SplitLibExtractor(sourceApk, splitLibDir);
            try {
                List<File> libFiles = extractor.load(info, false);
                SplitLog.i((String)TAG, (String)"Succeed to extract libs:  %s", (Object[])new Object[]{libFiles.toString()});
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)"Failed to load or extract lib files", (Throwable)e);
                throw new SplitInstaller.InstallException(-15, (Throwable)e);
            }
            finally {
                FileUtil.closeQuietly((Object)extractor);
            }
        }
        catch (IOException ioError) {
            throw new SplitInstaller.InstallException(-15, (Throwable)ioError);
        }
    }

    @Override
    protected boolean createInstalledMark(File markFile) throws SplitInstaller.InstallException {
        if (!markFile.exists()) {
            try {
                FileUtil.createFileSafely((File)markFile);
                return true;
            }
            catch (IOException e) {
                throw new SplitInstaller.InstallException(-16, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected boolean createInstalledMarkLock(File markFile, File lockFile) throws SplitInstaller.InstallException {
        if (!markFile.exists()) {
            try {
                FileUtil.createFileSafelyLock((File)markFile, (File)lockFile);
                return true;
            }
            catch (IOException e) {
                throw new SplitInstaller.InstallException(-16, (Throwable)e);
            }
        }
        return false;
    }

    private boolean isVMMultiDexCapable() {
        return IS_VM_MULTIDEX_CAPABLE;
    }

    private boolean isMultiDexExtractNeeded(SplitInfo info) {
        return info.isMultiDex();
    }

    private boolean isLibExtractNeeded(SplitInfo info) {
        return info.hasLibs();
    }

    private void deleteCorruptedFiles(List<File> files) {
        for (File file : files) {
            FileUtil.deleteFileSafely((File)file);
        }
    }

    private static boolean isVMMultiDexCapable(String versionString) {
        Matcher matcher;
        boolean isMultiDexCapable = false;
        if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                isMultiDexCapable = major > 2 || major == 2 && minor >= 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SplitLog.i((String)"Split:MultiDex", (String)("VM with version " + versionString + (isMultiDexCapable ? " has multidex support" : " does not have multidex support")), (Object[])new Object[0]);
        return isMultiDexCapable;
    }
}

