/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.content.SharedPreferences;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

final class SplitMultiDexExtractor
implements Closeable {
    private static final String TAG = "Split:MultiDexExtractor";
    private static final String DEX_PREFIX = "classes";
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String PREFS_FILE = "split.multidex.version";
    private static final String KEY_TIME_STAMP = "timestamp";
    private static final String KEY_CRC = "crc";
    private static final String KEY_DEX_NUMBER = "dex.number";
    private static final String KEY_DEX_CRC = "dex.crc.";
    private static final String KEY_DEX_TIME = "dex.time.";
    private static final long NO_VALUE = -1L;
    private static final String LOCK_FILENAME = "SplitMultiDex.lock";
    private final File sourceApk;
    private final long sourceCrc;
    private final File dexDir;
    private final RandomAccessFile lockRaf;
    private final FileChannel lockChannel;
    private final FileLock cacheLock;

    SplitMultiDexExtractor(File sourceApk, File dexDir) throws IOException {
        SplitLog.i((String)TAG, (String)("SplitMultiDexExtractor(" + sourceApk.getPath() + ", " + dexDir.getPath() + ")"), (Object[])new Object[0]);
        this.sourceApk = sourceApk;
        this.dexDir = dexDir;
        this.sourceCrc = SplitMultiDexExtractor.getZipCrc(sourceApk);
        File lockFile = new File(dexDir, LOCK_FILENAME);
        this.lockRaf = new RandomAccessFile(lockFile, "rw");
        try {
            this.lockChannel = this.lockRaf.getChannel();
            try {
                SplitLog.i((String)TAG, (String)("Blocking on lock " + lockFile.getPath()), (Object[])new Object[0]);
                this.cacheLock = this.lockChannel.lock();
            }
            catch (IOException | Error | RuntimeException var5) {
                SplitMultiDexExtractor.closeQuietly(this.lockChannel);
                throw var5;
            }
            SplitLog.i((String)TAG, (String)(lockFile.getPath() + " locked"), (Object[])new Object[0]);
        }
        catch (IOException | Error | RuntimeException var6) {
            SplitMultiDexExtractor.closeQuietly(this.lockRaf);
            throw var6;
        }
    }

    List<? extends File> load(Context context, String prefsKeyPrefix, boolean forceReload) throws IOException {
        List<File> files;
        SplitLog.i((String)TAG, (String)("SplitMultiDexExtractor.load(" + this.sourceApk.getPath() + ", " + forceReload + ", " + prefsKeyPrefix + ")"), (Object[])new Object[0]);
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("SplitMultiDexExtractor was closed");
        }
        if (!forceReload && !SplitMultiDexExtractor.isModified(context, this.sourceApk, this.sourceCrc, prefsKeyPrefix)) {
            try {
                files = this.loadExistingExtractions(context, prefsKeyPrefix);
            }
            catch (IOException var6) {
                SplitLog.w((String)TAG, (String)"Failed to reload existing extracted secondary dex files, falling back to fresh extraction", (Throwable)var6);
                files = this.performExtractions();
                SplitMultiDexExtractor.putStoredApkInfo(context, prefsKeyPrefix, SplitMultiDexExtractor.getTimeStamp(this.sourceApk), this.sourceCrc, files);
            }
        } else {
            if (forceReload) {
                SplitLog.i((String)TAG, (String)"Forced extraction must be performed.", (Object[])new Object[0]);
            } else {
                SplitLog.i((String)TAG, (String)"Detected that extraction must be performed.", (Object[])new Object[0]);
            }
            files = this.performExtractions();
            SplitMultiDexExtractor.putStoredApkInfo(context, prefsKeyPrefix, SplitMultiDexExtractor.getTimeStamp(this.sourceApk), this.sourceCrc, files);
        }
        SplitLog.i((String)TAG, (String)("load found " + files.size() + " secondary dex files"), (Object[])new Object[0]);
        return files;
    }

    @Override
    public void close() throws IOException {
        this.cacheLock.release();
        this.lockChannel.close();
        this.lockRaf.close();
    }

    private List<? extends File> loadExistingExtractions(Context context, String prefsKeyPrefix) throws IOException {
        SplitLog.i((String)TAG, (String)"loading existing secondary dex files", (Object[])new Object[0]);
        String extractedFilePrefix = this.sourceApk.getName() + EXTRACTED_NAME_EXT;
        SharedPreferences multiDexPreferences = SplitMultiDexExtractor.getMultiDexPreferences(context);
        int totalDexNumber = multiDexPreferences.getInt(prefsKeyPrefix + KEY_DEX_NUMBER, 1);
        ArrayList<ExtractedDex> files = new ArrayList<ExtractedDex>(totalDexNumber - 1);
        for (int secondaryNumber = 2; secondaryNumber <= totalDexNumber; ++secondaryNumber) {
            long lastModified;
            String fileName = extractedFilePrefix + secondaryNumber + ".zip";
            ExtractedDex extractedFile = new ExtractedDex(this.dexDir, fileName);
            if (!extractedFile.isFile()) {
                throw new IOException("Missing extracted secondary dex file '" + extractedFile.getPath() + "'");
            }
            extractedFile.crc = SplitMultiDexExtractor.getZipCrc(extractedFile);
            long expectedCrc = multiDexPreferences.getLong(prefsKeyPrefix + KEY_DEX_CRC + secondaryNumber, -1L);
            long expectedModTime = multiDexPreferences.getLong(prefsKeyPrefix + KEY_DEX_TIME + secondaryNumber, -1L);
            if (expectedModTime != (lastModified = extractedFile.lastModified()) || expectedCrc != extractedFile.crc) {
                throw new IOException("Invalid extracted dex: " + extractedFile + " (key \"" + prefsKeyPrefix + "\"), expected modification time: " + expectedModTime + ", modification time: " + lastModified + ", expected crc: " + expectedCrc + ", file crc: " + extractedFile.crc);
            }
            files.add(extractedFile);
        }
        SplitLog.i((String)TAG, (String)"Existing secondary dex files loaded", (Object[])new Object[0]);
        return files;
    }

    private static boolean isModified(Context context, File archive, long currentCrc, String prefsKeyPrefix) {
        SharedPreferences prefs = SplitMultiDexExtractor.getMultiDexPreferences(context);
        return prefs.getLong(prefsKeyPrefix + KEY_TIME_STAMP, 1L) != SplitMultiDexExtractor.getTimeStamp(archive) || prefs.getLong(prefsKeyPrefix + KEY_CRC, 1L) != currentCrc;
    }

    private static long getTimeStamp(File archive) {
        long timeStamp = archive.lastModified();
        if (timeStamp == 1L) {
            --timeStamp;
        }
        return timeStamp;
    }

    private static long getZipCrc(File archive) throws IOException {
        long computedValue = ZipCrcUtil.getZipCrc(archive);
        if (computedValue == 1L) {
            --computedValue;
        }
        return computedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractedDex> performExtractions() throws IOException {
        String extractedFilePrefix = this.sourceApk.getName() + EXTRACTED_NAME_EXT;
        this.clearDexDir();
        ArrayList<ExtractedDex> files = new ArrayList<ExtractedDex>();
        ZipFile apk = new ZipFile(this.sourceApk);
        try {
            int secondaryNumber = 2;
            ZipEntry dexFile = apk.getEntry(DEX_PREFIX + secondaryNumber + ".dex");
            while (dexFile != null) {
                String fileName = extractedFilePrefix + secondaryNumber + ".zip";
                ExtractedDex extractedFile = new ExtractedDex(this.dexDir, fileName);
                files.add(extractedFile);
                SplitLog.i((String)TAG, (String)("Extraction is needed for file " + extractedFile), (Object[])new Object[0]);
                int numAttempts = 0;
                boolean isExtractionSuccessful = false;
                while (numAttempts < 3 && !isExtractionSuccessful) {
                    ++numAttempts;
                    SplitMultiDexExtractor.extract(apk, dexFile, extractedFile, extractedFilePrefix);
                    try {
                        extractedFile.crc = SplitMultiDexExtractor.getZipCrc(extractedFile);
                        isExtractionSuccessful = true;
                    }
                    catch (IOException var18) {
                        isExtractionSuccessful = false;
                        SplitLog.w((String)TAG, (String)("Failed to read crc from " + extractedFile.getAbsolutePath()), (Throwable)var18);
                    }
                    SplitLog.i((String)TAG, (String)("Extraction " + (isExtractionSuccessful ? "succeeded" : "failed") + " '" + extractedFile.getAbsolutePath() + "': length " + extractedFile.length() + " - crc: " + extractedFile.crc), (Object[])new Object[0]);
                    if (isExtractionSuccessful) continue;
                    extractedFile.delete();
                    if (!extractedFile.exists()) continue;
                    SplitLog.w((String)TAG, (String)("Failed to delete corrupted secondary dex '" + extractedFile.getPath() + "'"), (Object[])new Object[0]);
                }
                if (!isExtractionSuccessful) {
                    throw new IOException("Could not create zip file " + extractedFile.getAbsolutePath() + " for secondary dex (" + secondaryNumber + ")");
                }
                dexFile = apk.getEntry(DEX_PREFIX + ++secondaryNumber + ".dex");
            }
        }
        finally {
            try {
                apk.close();
            }
            catch (IOException var17) {
                SplitLog.w((String)TAG, (String)"Failed to close resource", (Throwable)var17);
            }
        }
        return files;
    }

    private static void putStoredApkInfo(Context context, String keyPrefix, long timeStamp, long crc, List<ExtractedDex> extractedDexes) {
        SharedPreferences prefs = SplitMultiDexExtractor.getMultiDexPreferences(context);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(keyPrefix + KEY_TIME_STAMP, timeStamp);
        edit.putLong(keyPrefix + KEY_CRC, crc);
        edit.putInt(keyPrefix + KEY_DEX_NUMBER, extractedDexes.size() + 1);
        int extractedDexId = 2;
        for (ExtractedDex dex : extractedDexes) {
            edit.putLong(keyPrefix + KEY_DEX_CRC + extractedDexId, dex.crc);
            edit.putLong(keyPrefix + KEY_DEX_TIME + extractedDexId, dex.lastModified());
            ++extractedDexId;
        }
        edit.apply();
    }

    private static SharedPreferences getMultiDexPreferences(Context context) {
        return context.getSharedPreferences(PREFS_FILE, 4);
    }

    private void clearDexDir() {
        File[] files = this.dexDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().equals(SplitMultiDexExtractor.LOCK_FILENAME);
            }
        });
        if (files == null) {
            SplitLog.w((String)TAG, (String)("Failed to list secondary dex dir content (" + this.dexDir.getPath() + ")."), (Object[])new Object[0]);
        } else {
            File[] var2 = files;
            int var3 = files.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                File oldFile = var2[var4];
                SplitLog.i((String)TAG, (String)("Trying to delete old file " + oldFile.getPath() + " of size " + oldFile.length()), (Object[])new Object[0]);
                if (!oldFile.delete()) {
                    SplitLog.w((String)TAG, (String)("Failed to delete old file " + oldFile.getPath()), (Object[])new Object[0]);
                    continue;
                }
                SplitLog.i((String)TAG, (String)("Deleted old file " + oldFile.getPath()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ZipFile apk, ZipEntry dexFile, File extractTo, String extractedFilePrefix) throws IOException {
        InputStream in = apk.getInputStream(dexFile);
        File tmp = File.createTempFile("tmp-" + extractedFilePrefix, ".zip", extractTo.getParentFile());
        SplitLog.i((String)TAG, (String)("Extracting " + tmp.getPath()), (Object[])new Object[0]);
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));
            try {
                ZipEntry classesDex = new ZipEntry("classes.dex");
                classesDex.setTime(dexFile.getTime());
                out.putNextEntry(classesDex);
                byte[] buffer = new byte[16384];
                int length = in.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = in.read(buffer);
                }
                out.closeEntry();
            }
            finally {
                SplitMultiDexExtractor.closeQuietly(out);
            }
            if (!tmp.setReadOnly()) {
                throw new IOException("Failed to mark readonly \"" + tmp.getAbsolutePath() + "\" (tmp of \"" + extractTo.getAbsolutePath() + "\")");
            }
            SplitLog.i((String)TAG, (String)("Renaming to " + extractTo.getPath()), (Object[])new Object[0]);
            if (!tmp.renameTo(extractTo)) {
                throw new IOException("Failed to rename \"" + tmp.getAbsolutePath() + "\" to \"" + extractTo.getAbsolutePath() + "\"");
            }
        }
        finally {
            SplitMultiDexExtractor.closeQuietly(in);
            tmp.delete();
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException var2) {
            SplitLog.w((String)TAG, (String)"Failed to close resource", (Throwable)var2);
        }
    }

    static class CentralDirectory {
        long offset;
        long size;

        CentralDirectory() {
        }
    }

    static final class ZipCrcUtil {
        ZipCrcUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static long getZipCrc(File apk) throws IOException {
            long var3;
            try (RandomAccessFile raf = new RandomAccessFile(apk, "r");){
                CentralDirectory dir = ZipCrcUtil.findCentralDirectory(raf);
                var3 = ZipCrcUtil.computeCrcOfCentralDir(raf, dir);
            }
            return var3;
        }

        private static CentralDirectory findCentralDirectory(RandomAccessFile raf) throws IOException, ZipException {
            long scanOffset = raf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + raf.length());
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            int endSig = Integer.reverseBytes(101010256);
            do {
                raf.seek(scanOffset);
                if (raf.readInt() != endSig) continue;
                raf.skipBytes(2);
                raf.skipBytes(2);
                raf.skipBytes(2);
                raf.skipBytes(2);
                CentralDirectory dir = new CentralDirectory();
                dir.size = (long)Integer.reverseBytes(raf.readInt()) & 0xFFFFFFFFL;
                dir.offset = (long)Integer.reverseBytes(raf.readInt()) & 0xFFFFFFFFL;
                return dir;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }

        private static long computeCrcOfCentralDir(RandomAccessFile raf, CentralDirectory dir) throws IOException {
            CRC32 crc = new CRC32();
            long stillToRead = dir.size;
            raf.seek(dir.offset);
            int length = (int)Math.min(16384L, stillToRead);
            byte[] buffer = new byte[16384];
            length = raf.read(buffer, 0, length);
            while (length != -1) {
                crc.update(buffer, 0, length);
                if ((stillToRead -= (long)length) == 0L) break;
                length = (int)Math.min(16384L, stillToRead);
                length = raf.read(buffer, 0, length);
            }
            return crc.getValue();
        }
    }

    private static class ExtractedDex
    extends File {
        long crc = 1L;

        ExtractedDex(File dexDir, String fileName) {
            super(dexDir, fileName);
        }
    }
}

