/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Intent;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallReporterManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.util.ArrayList;
import java.util.List;

final class SplitStartInstallTask
extends SplitInstallTask {
    private final SplitInstallSessionManager mSessionManager;
    private final SplitInstallInternalSessionState mSessionState;

    SplitStartInstallTask(int sessionId, SplitInstaller installer, SplitInstallSessionManager sessionManager, List<SplitInfo> splitInfoList) {
        super(installer, splitInfoList);
        this.mSessionState = sessionManager.getSessionState(sessionId);
        this.mSessionManager = sessionManager;
    }

    @Override
    boolean isStartInstallOperation() {
        return true;
    }

    @Override
    protected void onPreInstall() {
        super.onPreInstall();
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 4);
        this.emitSessionStatus();
    }

    @Override
    protected void onInstallCompleted(List<SplitInstaller.InstallResult> installResults, long cost) {
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>(installResults.size());
        for (SplitInstaller.InstallResult installResult : installResults) {
            Intent splitFileIntent = new Intent();
            if (installResult.addedDexPaths != null) {
                splitFileIntent.putStringArrayListExtra("added-dex", (ArrayList)installResult.addedDexPaths);
            }
            splitFileIntent.putExtra("apk", installResult.apkFile.getAbsolutePath());
            splitFileIntent.putExtra("splitName", installResult.splitName);
            splitFileIntents.add(splitFileIntent);
        }
        this.mSessionState.setSplitFileIntents(splitFileIntents);
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 10);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallOK(this.splitBriefInfoList, cost);
        }
    }

    @Override
    protected void onInstallFailed(List<SplitInstallError> errors, long cost) {
        this.mSessionState.setErrorCode(errors.get((int)0).errorCode);
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 6);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallFailed(this.splitBriefInfoList, errors.get(0), cost);
        }
    }

    private void emitSessionStatus() {
        this.mSessionManager.emitSessionState(this.mSessionState);
    }
}

