/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Intent;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallReporterManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class SplitStartInstallTask
extends SplitInstallTask {
    private final SplitInstallSessionManager mSessionManager;
    private final SplitInstallInternalSessionState mSessionState;

    SplitStartInstallTask(int sessionId, SplitInstaller installer, SplitInstallSessionManager sessionManager, List<String> moduleNames, List<SplitInfo> splitInfoList) {
        super(installer, moduleNames, splitInfoList);
        this.mSessionState = sessionManager.getSessionState(sessionId);
        this.mSessionManager = sessionManager;
    }

    @Override
    boolean continueInstallIgnoreError() {
        return false;
    }

    @Override
    protected void onPreInstall() {
        super.onPreInstall();
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 4);
        this.emitSessionStatus();
    }

    @Override
    protected void onInstallCompleted(List<SplitInstaller.InstallResult> installResults, long cost) {
        ArrayList<SplitInstallError> installErrors = new ArrayList<SplitInstallError>(0);
        for (SplitInstaller.InstallResult installResult : installResults) {
            if (installResult.dependenciesInstalled) continue;
            IOException exception = new IOException("Split " + installResult.splitName + "' dependencies are not installed!");
            installErrors.add(new SplitInstallError(installResult.splitName, -18, (Throwable)exception));
        }
        if (!installErrors.isEmpty()) {
            this.onInstallFailed(installErrors, cost);
            return;
        }
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>(installResults.size());
        for (SplitInstaller.InstallResult installResult : installResults) {
            Intent splitFileIntent = new Intent();
            if (installResult.addedDexPaths != null) {
                splitFileIntent.putStringArrayListExtra("added-dex", (ArrayList)installResult.addedDexPaths);
            }
            splitFileIntent.putExtra("apk", installResult.apkFile.getAbsolutePath());
            splitFileIntent.putExtra("splitName", installResult.splitName);
            splitFileIntents.add(splitFileIntent);
        }
        this.mSessionState.setSplitFileIntents(splitFileIntents);
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 10);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallOK(this.moduleNames, cost);
        }
    }

    @Override
    protected void onInstallFailed(List<SplitInstallError> errors, long cost) {
        this.mSessionState.setErrorCode(errors.get(0).getErrorCode());
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 6);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallFailed(this.moduleNames, errors.get(0), cost);
        }
    }

    private void emitSessionStatus() {
        this.mSessionManager.emitSessionState(this.mSessionState);
    }
}

