/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.support.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.extension.ComponentInfoManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SplitComponentInfoProvider {
    private final Set<String> splitNames;

    SplitComponentInfoProvider(@NonNull Set<String> splitNames) {
        this.splitNames = splitNames;
    }

    String getSplitApplicationName(String splitName) {
        return ComponentInfoManager.getSplitApplication(splitName);
    }

    @NonNull
    Map<String, List<String>> getSplitActivitiesMap() {
        HashMap<String, List<String>> splitActivitiesMap = new HashMap<String, List<String>>(0);
        for (String splitName : this.splitNames) {
            String[] result = ComponentInfoManager.getSplitActivities(splitName);
            if (result == null || result.length <= 0) continue;
            ArrayList activities = new ArrayList();
            Collections.addAll(activities, result);
            splitActivitiesMap.put(splitName, activities);
        }
        return splitActivitiesMap;
    }

    @NonNull
    List<String> getSplitServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (String splitName : this.splitNames) {
            String[] result = ComponentInfoManager.getSplitServices(splitName);
            if (result == null || result.length <= 0) continue;
            Collections.addAll(services, result);
        }
        return services;
    }

    @NonNull
    List<String> getSplitReceivers() {
        ArrayList<String> receivers = new ArrayList<String>();
        for (String splitName : this.splitNames) {
            String[] result = ComponentInfoManager.getSplitReceivers(splitName);
            if (result == null || result.length <= 0) continue;
            Collections.addAll(receivers, result);
        }
        return receivers;
    }
}

