/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ContentProviderProxy
extends ContentProvider {
    private static final String TAG = "Split:ContentProviderProxy";
    private ContentProvider realContentProvider;
    private static final String NAME_INFIX = "_Decorated_";
    private ProviderInfo providerInfo;
    private String realContentProviderClassName;
    private String splitName;

    protected ContentProvider getRealContentProvider() {
        return this.realContentProvider;
    }

    void activateRealContentProvider(ClassLoader classLoader) throws AABExtensionException {
        ReflectiveOperationException error = null;
        try {
            this.realContentProvider = this.createRealContentProvider(classLoader);
        }
        catch (ClassNotFoundException e) {
            error = e;
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (InstantiationException e) {
            error = e;
        }
        if (error != null) {
            throw new AABExtensionException(error);
        }
    }

    private ContentProvider createRealContentProvider(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.getContext() == null || this.realContentProviderClassName == null) {
            SplitLog.w((String)TAG, (String)("Cause of null context, we can't create real provider " + this.realContentProviderClassName), (Object[])new Object[0]);
            return null;
        }
        ContentProvider realContentProvider = (ContentProvider)classLoader.loadClass(this.realContentProviderClassName).newInstance();
        realContentProvider.attachInfo(this.getContext(), this.providerInfo);
        SplitLog.d((String)TAG, (String)("Success to create provider " + this.realContentProviderClassName), (Object[])new Object[0]);
        return realContentProvider;
    }

    public boolean onCreate() {
        return true;
    }

    protected abstract boolean checkRealContentProviderInstallStatus(String var1);

    public void attachInfo(Context context, ProviderInfo info) {
        String className = ((Object)((Object)this)).getClass().getName();
        String[] cuts = className.split(NAME_INFIX);
        this.realContentProviderClassName = cuts[0];
        this.splitName = cuts[1];
        super.attachInfo(context, info);
        this.providerInfo = new ProviderInfo(info);
        AABExtension.getInstance().put(this.splitName, this);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            this.realContentProvider.onConfigurationChanged(newConfig);
        }
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        return null;
    }

    @RequiresApi(api=26)
    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable Bundle queryArgs, @Nullable CancellationSignal cancellationSignal) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.query(uri, projection, queryArgs, cancellationSignal);
        }
        return super.query(uri, projection, queryArgs, cancellationSignal);
    }

    @RequiresApi(api=16)
    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder, @Nullable CancellationSignal cancellationSignal) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
        }
        return super.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.getType(uri);
        }
        return null;
    }

    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.applyBatch(operations);
        }
        return super.applyBatch(operations);
    }

    @RequiresApi(api=19)
    @Nullable
    public Uri canonicalize(@NonNull Uri url) {
        if (this.getRealContentProvider() != null) {
            return this.realContentProvider.canonicalize(url);
        }
        return super.canonicalize(url);
    }

    @RequiresApi(api=19)
    @Nullable
    public Uri uncanonicalize(@NonNull Uri url) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.uncanonicalize(url);
        }
        return super.uncanonicalize(url);
    }

    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri uri, @NonNull String mode) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openAssetFile(uri, mode);
        }
        return super.openAssetFile(uri, mode);
    }

    @RequiresApi(api=19)
    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal signal) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openAssetFile(uri, mode, signal);
        }
        return super.openAssetFile(uri, mode, signal);
    }

    @RequiresApi(api=19)
    @Nullable
    public AssetFileDescriptor openTypedAssetFile(@NonNull Uri uri, @NonNull String mimeTypeFilter, @Nullable Bundle opts) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openTypedAssetFile(uri, mimeTypeFilter, opts);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    @RequiresApi(api=19)
    @Nullable
    public AssetFileDescriptor openTypedAssetFile(@NonNull Uri uri, @NonNull String mimeTypeFilter, @Nullable Bundle opts, @Nullable CancellationSignal signal) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
    }

    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openFile(uri, mode);
        }
        return super.openFile(uri, mode);
    }

    @RequiresApi(api=19)
    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal signal) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openFile(uri, mode, signal);
        }
        return super.openFile(uri, mode, signal);
    }

    @NonNull
    public <T> ParcelFileDescriptor openPipeHelper(@NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts, @Nullable T args, @NonNull ContentProvider.PipeDataWriter<T> func) throws FileNotFoundException {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.openPipeHelper(uri, mimeType, opts, args, func);
        }
        return super.openPipeHelper(uri, mimeType, opts, args, func);
    }

    @RequiresApi(api=26)
    public boolean refresh(Uri uri, @Nullable Bundle args, @Nullable CancellationSignal cancellationSignal) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.refresh(uri, args, cancellationSignal);
        }
        return super.refresh(uri, args, cancellationSignal);
    }

    @Nullable
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.call(method, arg, extras);
        }
        return super.call(method, arg, extras);
    }

    @Nullable
    public String[] getStreamTypes(@NonNull Uri uri, @NonNull String mimeTypeFilter) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.getStreamTypes(uri, mimeTypeFilter);
        }
        return super.getStreamTypes(uri, mimeTypeFilter);
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.insert(uri, values);
        }
        return null;
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.realContentProvider != null) {
            this.realContentProvider.onTrimMemory(level);
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.realContentProvider != null) {
            this.realContentProvider.onLowMemory();
        }
    }

    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.bulkInsert(uri, values);
        }
        return super.bulkInsert(uri, values);
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.delete(uri, selection, selectionArgs);
        }
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        if (this.checkRealContentProviderInstallStatus(this.splitName)) {
            return this.realContentProvider.update(uri, values, selection, selectionArgs);
        }
        return 0;
    }
}

