/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManager;
import com.iqiyi.android.qigsaw.core.extension.SplitComponentInfoProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

final class AABExtensionManagerImpl
implements AABExtensionManager {
    private SplitComponentInfoProvider infoProvider;
    private List<String> splitActivities;
    private List<String> splitServices;
    private List<String> splitReceivers;

    AABExtensionManagerImpl(SplitComponentInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    public Application createApplication(ClassLoader classLoader, String splitName) throws AABExtensionException {
        ReflectiveOperationException error = null;
        String applicationName = this.infoProvider.getSplitApplicationName(splitName);
        if (!TextUtils.isEmpty((CharSequence)applicationName)) {
            try {
                Class<?> appClass = classLoader.loadClass(applicationName);
                return (Application)appClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                error = e;
            }
            catch (InstantiationException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
        }
        if (error != null) {
            throw new AABExtensionException(error);
        }
        return null;
    }

    @Override
    @SuppressLint(value={"DiscouragedPrivateApi"})
    public void activeApplication(Application app, Context appContext) throws AABExtensionException {
        if (app != null) {
            ReflectiveOperationException error = null;
            try {
                Method method = Application.class.getDeclaredMethod("attach", Context.class);
                method.setAccessible(true);
                method.invoke((Object)app, appContext);
            }
            catch (NoSuchMethodException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
            catch (InvocationTargetException e) {
                error = e;
            }
            if (error != null) {
                throw new AABExtensionException(error);
            }
        }
    }

    @Override
    public boolean isSplitActivity(String name) {
        if (this.splitActivities == null) {
            this.splitActivities = this.infoProvider.getSplitActivities();
        }
        return this.splitActivities.contains(name);
    }

    @Override
    public boolean isSplitService(String name) {
        if (this.splitServices == null) {
            this.splitServices = this.infoProvider.getSplitServices();
        }
        return this.splitServices.contains(name);
    }

    @Override
    public boolean isSplitReceiver(String name) {
        if (this.splitReceivers == null) {
            this.splitReceivers = this.infoProvider.getSplitReceivers();
        }
        return this.splitReceivers.contains(name);
    }
}

