/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitElfFile;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.File;
import java.io.IOException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class OEMCompat {
    private static final String TAG = "Split.OEMCompat";

    public static boolean isSpecialManufacturer() {
        return "vivo".equalsIgnoreCase(Build.MANUFACTURER) || "oppo".equalsIgnoreCase(Build.MANUFACTURER) || "EEBBK".equalsIgnoreCase(Build.MANUFACTURER);
    }

    public static boolean shouldCheckOatFileInCurrentSys() {
        return Build.VERSION.SDK_INT > 20 && Build.VERSION.SDK_INT < 26;
    }

    public static File getOatFilePath(@NonNull File sourceApk, @NonNull File optimizedDirectory) {
        String fileName = sourceApk.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            fileName = lastDot < 0 ? fileName + ".dex" : fileName.substring(0, lastDot) + ".dex";
        }
        return new File(optimizedDirectory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkOatFile(@NonNull File oatFile) {
        int returnType;
        try {
            returnType = SplitElfFile.getFileTypeByMagic(oatFile);
        }
        catch (IOException e) {
            return true;
        }
        if (returnType == 1) {
            boolean bl;
            SplitElfFile elfFile = null;
            try {
                elfFile = new SplitElfFile(oatFile);
                bl = true;
            }
            catch (Throwable e) {
                try {
                    SplitLog.e(TAG, "final parallel dex optimizer file %s is not elf format, return false", oatFile.getName());
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(elfFile);
                    throw throwable;
                }
                FileUtil.closeQuietly(elfFile);
            }
            FileUtil.closeQuietly(elfFile);
            return bl;
        }
        return false;
    }
}

