/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SplitAABInfoProvider {
    private static final String TAG = "SplitAABInfoProvider";
    private Context context;
    private final String packageName;

    public SplitAABInfoProvider(Context context) {
        this.packageName = context.getPackageName();
        this.context = context;
    }

    public Set<String> getInstalledSplitsForAAB() {
        Set<String> installedModules = this.getFusedModules();
        if (Build.VERSION.SDK_INT < 21) {
            return installedModules;
        }
        Object[] splitNames = this.getSplitInstallInfo();
        if (splitNames == null) {
            SplitLog.d(TAG, "No splits are found or app cannot be found in package manager.", new Object[0]);
            return installedModules;
        }
        String logMsg = "Split names are: ";
        String splitNamesStr = Arrays.toString(splitNames);
        SplitLog.d(TAG, splitNamesStr.length() != 0 ? logMsg.concat(splitNamesStr) : logMsg, new Object[0]);
        for (Object splitName : splitNames) {
            if (((String)splitName).startsWith("config.")) continue;
            installedModules.add(this.cutSplitName((String)splitName));
        }
        return installedModules;
    }

    private Set<String> getFusedModules() {
        ApplicationInfo appInfo;
        HashSet<String> fusedModules = new HashSet<String>();
        try {
            appInfo = this.context.getPackageManager().getApplicationInfo(this.packageName, 128);
        }
        catch (Throwable e) {
            SplitLog.printErrStackTrace(TAG, e, "App is not found in PackageManager", new Object[0]);
            return fusedModules;
        }
        if (appInfo != null && appInfo.metaData != null) {
            String fusedName = appInfo.metaData.getString("shadow.bundletool.com.android.dynamic.apk.fused.modules");
            if (fusedName != null && !fusedName.isEmpty()) {
                Collections.addAll(fusedModules, fusedName.split(",", -1));
                fusedModules.remove("");
                return fusedModules;
            }
            SplitLog.d(TAG, "App has no fused modules.", new Object[0]);
            return fusedModules;
        }
        SplitLog.d(TAG, "App has no applicationInfo or metaData", new Object[0]);
        return fusedModules;
    }

    private String cutSplitName(String splitName) {
        return splitName.split("\\.config\\.")[0];
    }

    @RequiresApi(api=21)
    private String[] getSplitInstallInfo() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.packageName, 0);
            return packageInfo != null ? packageInfo.splitNames : null;
        }
        catch (Throwable var2) {
            SplitLog.printErrStackTrace(TAG, var2, "App is not found in PackageManager", new Object[0]);
            return null;
        }
    }
}

