/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.xstructural.maven_plugin;

import com.io7m.xstructural.api.XSProcessorException;
import com.io7m.xstructural.api.XSProcessorRequest;
import com.io7m.xstructural.api.XSProcessorRequestType;
import com.io7m.xstructural.api.XSProcessorType;
import com.io7m.xstructural.vanilla.XSProcessors;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="xhtml-multi")
public final class XSXHTMLMultiMojo
extends AbstractMojo {
    @Parameter(name="outputDirectory", required=true)
    private String outputDirectory;
    @Parameter(name="sourceFile", required=true)
    private String sourceFile;
    @Parameter(name="brandingFile", required=false)
    private String brandingFile;
    @Parameter(name="copyResources", defaultValue="true", required=false)
    private boolean copyResources;
    @Parameter(required=false, name="skip", property="xstructural.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        try {
            XSProcessorRequest.Builder requestBuilder = XSProcessorRequest.builder();
            requestBuilder.setOutputDirectory(Paths.get(this.outputDirectory, new String[0]).toAbsolutePath());
            requestBuilder.setSourceFile(Paths.get(this.sourceFile, new String[0]).toAbsolutePath());
            requestBuilder.setStylesheet(XSProcessorRequestType.Stylesheet.MULTIPLE_FILE);
            requestBuilder.setTask(XSProcessorRequestType.Task.TRANSFORM_XHTML);
            requestBuilder.setWriteResources(this.copyResources);
            if (this.brandingFile != null) {
                requestBuilder.setBrandingFile(Paths.get(this.brandingFile, new String[0]).toAbsolutePath());
            }
            XSProcessorRequest request = requestBuilder.build();
            XSProcessors processors = new XSProcessors();
            XSProcessorType processor = processors.create(request);
            processor.execute();
        }
        catch (XSProcessorException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

