/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jequality.validator;

import com.io7m.jequality.annotations.EqualityReference;
import com.io7m.jequality.annotations.EqualityStructural;
import com.io7m.jequality.validator.AnnotationRequirement;
import com.io7m.jequality.validator.ValidatorResult;
import com.io7m.junreachable.UnreachableCodeException;
import java.lang.reflect.Method;
import java.util.Objects;

public final class EqualityValidator {
    private EqualityValidator() {
        throw new UnreachableCodeException();
    }

    public static ValidatorResult validateClass(Class<?> c, AnnotationRequirement requirement, boolean check_hashcode) {
        Objects.requireNonNull(c, "Class");
        Objects.requireNonNull(requirement, "Requirement");
        EqualityReference er = c.getAnnotation(EqualityReference.class);
        if (er != null) {
            return EqualityValidator.validateClassReferenceEquality(c, check_hashcode);
        }
        EqualityStructural es = c.getAnnotation(EqualityStructural.class);
        if (es != null) {
            return EqualityValidator.validateClassStructuralEquality(c, check_hashcode);
        }
        if (requirement == AnnotationRequirement.ANNOTATIONS_REQUIRED) {
            return ValidatorResult.VALIDATION_ERROR_WANTED_ANNOTATIONS;
        }
        return ValidatorResult.VALIDATION_OK;
    }

    private static ValidatorResult validateClassReferenceEquality(Class<?> c, boolean check_hashcode) {
        Method[] ms;
        boolean equals_ok = false;
        boolean hashcode_ok = false;
        for (Method m : ms = c.getMethods()) {
            if (Objects.equals("equals", m.getName()) && Objects.equals(m.getDeclaringClass(), Object.class)) {
                equals_ok = true;
            }
            if (!Objects.equals("hashCode", m.getName()) || !check_hashcode || !Objects.equals(m.getDeclaringClass(), Object.class)) continue;
            hashcode_ok = true;
        }
        if (!equals_ok) {
            return ValidatorResult.VALIDATION_ERROR_WANTED_REFERENCE_EQUALITY;
        }
        if (check_hashcode && !hashcode_ok) {
            return ValidatorResult.VALIDATION_ERROR_INCONSISTENT_HASHCODE;
        }
        return ValidatorResult.VALIDATION_OK;
    }

    private static ValidatorResult validateClassStructuralEquality(Class<?> c, boolean check_hashcode) {
        Method[] ms;
        boolean equals_ok = false;
        boolean hashcode_ok = false;
        for (Method m : ms = c.getMethods()) {
            if (Objects.equals("equals", m.getName()) && !Objects.equals(m.getDeclaringClass(), Object.class)) {
                equals_ok = true;
            }
            if (!Objects.equals("hashCode", m.getName()) || !check_hashcode || Objects.equals(m.getDeclaringClass(), Object.class)) continue;
            hashcode_ok = true;
        }
        if (!equals_ok) {
            return ValidatorResult.VALIDATION_ERROR_WANTED_STRUCTURAL_EQUALITY;
        }
        if (check_hashcode && !hashcode_ok) {
            return ValidatorResult.VALIDATION_ERROR_INCONSISTENT_HASHCODE;
        }
        return ValidatorResult.VALIDATION_OK;
    }
}

