/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jequality;

import com.io7m.jequality.annotations.EqualityReference;
import com.io7m.junreachable.UnreachableCodeException;

@EqualityReference
public final class AlmostEqualFloat {
    private AlmostEqualFloat() {
        throw new UnreachableCodeException();
    }

    public static boolean almostEqual(ContextRelative context, float x, float y) {
        float ay;
        if (x == Float.POSITIVE_INFINITY && y == Float.POSITIVE_INFINITY) {
            return true;
        }
        if (x == Float.NEGATIVE_INFINITY && y == Float.NEGATIVE_INFINITY) {
            return true;
        }
        float diff = Math.abs(x - y);
        if (diff <= context.getMaxAbsoluteDifference()) {
            return true;
        }
        float ax = Math.abs(x);
        float m = Math.max(ax, ay = Math.abs(y));
        float k = m * context.getMaxRelativeDifference();
        return diff <= k;
    }

    public static final class ContextRelative {
        private float max_absolute_diff = 0.0f;
        private float max_relative_diff = 0.0f;

        public float getMaxAbsoluteDifference() {
            return this.max_absolute_diff;
        }

        public void setMaxAbsoluteDifference(float max) {
            this.max_absolute_diff = max;
        }

        public float getMaxRelativeDifference() {
            return this.max_relative_diff;
        }

        public void setMaxRelativeDifference(float max) {
            this.max_relative_diff = max;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[ContextRelative [Absolute ");
            builder.append(this.max_absolute_diff);
            builder.append("] [Relative ");
            builder.append(this.max_relative_diff);
            builder.append("]]");
            String text = builder.toString();
            assert (text != null);
            return text;
        }
    }
}

