/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jequality;

import com.io7m.jequality.annotations.EqualityReference;
import com.io7m.junreachable.UnreachableCodeException;

@EqualityReference
public final class AlmostEqualDouble {
    private AlmostEqualDouble() {
        throw new UnreachableCodeException();
    }

    public static boolean almostEqual(ContextRelative context, double x, double y) {
        double ay;
        if (x == Double.POSITIVE_INFINITY && y == Double.POSITIVE_INFINITY) {
            return true;
        }
        if (x == Double.NEGATIVE_INFINITY && y == Double.NEGATIVE_INFINITY) {
            return true;
        }
        double diff = Math.abs(x - y);
        if (diff <= context.getMaxAbsoluteDifference()) {
            return true;
        }
        double ax = Math.abs(x);
        double m = Math.max(ax, ay = Math.abs(y));
        double k = m * context.getMaxRelativeDifference();
        return diff <= k;
    }

    public static final class ContextRelative {
        private double max_absolute_diff = 0.0;
        private double max_relative_diff = 0.0;

        public double getMaxAbsoluteDifference() {
            return this.max_absolute_diff;
        }

        public void setMaxAbsoluteDifference(double max) {
            this.max_absolute_diff = max;
        }

        public double getMaxRelativeDifference() {
            return this.max_relative_diff;
        }

        public void setMaxRelativeDifference(double max) {
            this.max_relative_diff = max;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[ContextRelative [Absolute ");
            builder.append(this.max_absolute_diff);
            builder.append("] [Relative ");
            builder.append(this.max_relative_diff);
            builder.append("]]");
            String text = builder.toString();
            assert (text != null);
            return text;
        }
    }
}

