package com.invms.awprotocol.model;

import android.location.Location;

import java.util.Date;

public class LocationModel {
    public static LocationModel create(Location location) {
        LocationModel model = new LocationModel();
        model.setLatitude(location.getLatitude());
        model.setLongitude(location.getLongitude());
        model.setAltitude(location.getAltitude());
        model.setSpeed(location.getSpeed());
        model.setBearing(location.getBearing());
        model.setAccuracy(location.getAccuracy());
        model.setTime(new Date(location.getTime()));
        return model;
    }

    protected double latitude;
    protected double longitude;
    protected double altitude;
    protected double speed;
    protected double bearing;
    protected double accuracy;
    protected Date time;

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getAltitude() {
        return altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getSpeed() {
        return speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getBearing() {
        return bearing;
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }

    public double getAccuracy() {
        return accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
}