package com.invms.awprotocol.invoker;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;

import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.WebResult;
import com.invms.awprotocol.model.LocationModel;

import java.util.List;

public class GetUpdateLocation extends BaseWebInvoker implements LocationListener {
    protected Long minTime;
    protected Float minDistance;
    protected LocationManager locationManager;

    @Override
    public boolean isCallback() {
        return true;
    }

    protected void initListener() {
        locationManager.removeUpdates(this);
        List<String> list = locationManager.getProviders(true);
        String provider;
        if (list.contains(LocationManager.GPS_PROVIDER)) {
            provider = LocationManager.GPS_PROVIDER;
        } else if (list.contains(LocationManager.NETWORK_PROVIDER)) {
            provider = LocationManager.NETWORK_PROVIDER;
        } else if (list.contains(LocationManager.PASSIVE_PROVIDER)) {
            provider = LocationManager.PASSIVE_PROVIDER;
        } else if (list.size() > 0) {
            provider = list.get(0);
        } else {
            Criteria criteria = new Criteria();
            criteria.setAccuracy(Criteria.ACCURACY_LOW);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setSpeedRequired(false);
            criteria.setCostAllowed(true);
            criteria.setPowerRequirement(Criteria.POWER_LOW);
            provider = locationManager.getBestProvider(criteria, true);
        }
        locationManager.requestLocationUpdates(provider, minTime, minDistance, this);
    }

    @Override
    public boolean invoke(String args) {
        JSONObject json = initCallback(args);
        minTime = json.getLong("minTime");
        minDistance = json.getFloat("minDistance");
        minTime = minTime == null || minTime < 0 ? 1000 : minTime;
        minDistance = minDistance == null || minDistance < 0 ? 1 : minDistance;
        initListener();
        return true;
    }

    @Override
    public boolean onCreate(Bundle savedInstanceState) {
        locationManager = (LocationManager) webActivity.getSystemService(Context.LOCATION_SERVICE);
        return true;
    }

    @Override
    public void onLocationChanged(Location location) {
        doneCallback(WebResult.createTrue(LocationModel.create(location)));
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
        initListener();
    }

    @Override
    public void onProviderDisabled(String provider) {
        initListener();
    }
}