package com.invms.awprotocol;

import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.SwitchPreference;

public class OptionFragment extends PreferenceFragment implements Preference.OnPreferenceChangeListener {
    protected SwitchPreference pWebDebug;
    protected EditTextPreference pWebKey;
    protected EditTextPreference pWebUrl;
    protected EditTextPreference pWebInvokers;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PreferenceManager manager = getPreferenceManager();
        manager.setSharedPreferencesName("awprotocol");
        addPreferencesFromResource(R.xml.option);
        pWebDebug = (SwitchPreference) findPreference("webDebug");
        pWebDebug.setChecked(AWRuntime.getConfig("webDebug", false));
        pWebDebug.setOnPreferenceChangeListener(this);
        pWebKey = (EditTextPreference) findPreference("webKey");
        pWebKey.setSummary(AWRuntime.getConfig("webKey", ""));
        pWebKey.setOnPreferenceChangeListener(this);
        pWebUrl = (EditTextPreference) findPreference("webUrl");
        pWebUrl.setSummary(AWRuntime.getConfig("webUrl", ""));
        pWebUrl.setOnPreferenceChangeListener(this);
        pWebInvokers = (EditTextPreference) findPreference("webInvokers");
        pWebInvokers.setSummary(AWRuntime.getConfig("webInvokers", ""));
        pWebInvokers.setOnPreferenceChangeListener(this);
    }

    @Override
    public boolean onPreferenceChange(Preference preference, Object value) {
        switch (preference.getKey()) {
            case "webDebug":
                boolean webDebug = (boolean) value;
                pWebDebug.setChecked(webDebug);
                AWRuntime.setConfig("webDebug", webDebug);
                break;
            case "webKey":
                String webKey = (String) value;
                pWebKey.setSummary(webKey);
                AWRuntime.setConfig("webKey", webKey);
                break;
            case "webUrl":
                String webUrl = (String) value;
                pWebUrl.setSummary(webUrl);
                AWRuntime.setConfig("webUrl", webUrl);
                break;
            case "webInvokers":
                String webInvokers = (String) value;
                pWebInvokers.setSummary(webInvokers);
                AWRuntime.setConfig("webInvokers", webInvokers);
                break;
        }
        return true;
    }
}