package com.invms.awprotocol;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;

@SuppressLint("SetJavaScriptEnabled")
public class WebActivity extends Activity {
    private static final String tag = WebActivity.class.getName();

    public static final int showFileResultCode = 1;

    protected long backTime;
    protected boolean webDebug;
    protected String webKey;
    protected String webUrl;
    protected WebView webView;
    protected WebClient webClient;
    protected WebChrome webChrome;
    protected WebHandler webHandler;

    protected Map<String, IWebInvoker> nameWebInvokers = new ConcurrentHashMap<>();
    protected Map<Integer, IWebInvoker> resultCodeWebInvokers = new ConcurrentHashMap<>();

    public boolean isWebDebug() {
        return webDebug;
    }

    public String getWebUrl() {
        return webUrl;
    }

    public WebView getWebView() {
        return webView;
    }

    public WebClient getWebClient() {
        return webClient;
    }

    public WebChrome getWebChrome() {
        return webChrome;
    }

    public WebHandler getWebHandler() {
        return webHandler;
    }

    public Map<String, IWebInvoker> getNameWebInvokers() {
        return nameWebInvokers;
    }

    public Map<Integer, IWebInvoker> getResultCodeWebInvokers() {
        return resultCodeWebInvokers;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            ActivityInfo activityInfo = getPackageManager().getActivityInfo(getComponentName(), PackageManager.GET_META_DATA);
            Bundle bundle = activityInfo.metaData;
            webDebug = AWRuntime.getConfig("webDebug", bundle.getBoolean("webDebug", false));
            Log.d(tag, "webDebug : " + webDebug);
            webKey = AWRuntime.getConfig("webKey", bundle.getString("webKey", "awprotocol"));
            Log.d(tag, "webKey : " + webKey);
            webUrl = AWRuntime.getConfig("webUrl", bundle.getString("webUrl", "file:///android_res/raw/index.html"));
            Log.d(tag, "webUrl : " + webUrl);
            WebView.setWebContentsDebuggingEnabled(webDebug);
            webView = new WebView(this);
            setContentView(webView);
            webClient = new WebClient(this);
            webView.setWebViewClient(webClient);
            webChrome = new WebChrome(this);
            webView.setWebChromeClient(webChrome);
            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
            webHandler = new WebHandler(this);
            webView.addJavascriptInterface(webHandler, webKey);
            webView.loadUrl(webUrl);
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case showFileResultCode:
                webChrome.callbackShowFile(WebChrome.FileChooserParams.parseResult(resultCode, data));
                return;
            default:
                IWebInvoker webInvoker = resultCodeWebInvokers.get(requestCode);
                if (webInvoker != null) {
                    Log.d(tag, webInvoker.getName() + " :callback: " + webInvoker.callback(this, resultCode, data));
                    return;
                }
                break;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case KeyEvent.KEYCODE_BACK:
                if (webView.canGoBack()) {
                    webView.goBack();
                } else {
                    long nowTime = (new Date()).getTime();
                    if (nowTime - backTime < 2000) {
                        finish();
                    } else {
                        backTime = nowTime;
                        Toast.makeText(this, "再按一次退出", Toast.LENGTH_SHORT).show();
                    }
                }
                return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void webCallback(String callback, Object data) {
        String script = "javascript:" + callback + "(" + AWRuntime.toJson(data) + ")";
        Log.d(tag, "webCallback : " + script);
        webView.evaluateJavascript(script, null);
    }

    public void addWebInvoker(IWebInvoker webInvoker) {
        nameWebInvokers.put(webInvoker.getName().toLowerCase(Locale.CHINA), webInvoker);
        resultCodeWebInvokers.put(webInvoker.getRequestCode(), webInvoker);
    }
}