/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.vision.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    protected static final String TAG = "OpenCameraSource";
    protected static final int DUMMY_TEXTURE_NAME = 100;
    protected static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    @Nullable
    protected Context mContext;
    protected final Object mCameraLock = new Object();
    @Nullable
    protected Camera mCamera;
    protected int mFacing = 0;
    protected int mRotation;
    protected Size mPreviewSize;
    protected float mRequestedFps = 30.0f;
    protected int mRequestedPreviewWidth = 1024;
    protected int mRequestedPreviewHeight = 768;
    @Nullable
    protected String mFocusMode = null;
    @Nullable
    protected String mFlashMode = null;
    @Nullable
    protected SurfaceView mDummySurfaceView;
    protected SurfaceTexture mDummySurfaceTexture;
    @Nullable
    protected Thread mProcessingThread;
    @Nullable
    protected FrameProcessingRunnable mFrameProcessor;
    @NonNull
    protected Map<byte[], ByteBuffer> mBytesToByteBuffer = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.stop();
            this.mFrameProcessor.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                return this;
            }
            this.mCamera = this.createCamera();
            if (Build.VERSION.SDK_INT >= 11) {
                this.mDummySurfaceTexture = new SurfaceTexture(100);
                this.mCamera.setPreviewTexture(this.mDummySurfaceTexture);
            } else {
                this.mDummySurfaceView = new SurfaceView(this.mContext);
                this.mCamera.setPreviewDisplay(this.mDummySurfaceView.getHolder());
            }
            this.mCamera.startPreview();
            this.mProcessingThread = new Thread(this.mFrameProcessor);
            this.mFrameProcessor.setActive(true);
            this.mProcessingThread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                return this;
            }
            this.mCamera = this.createCamera();
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.mCamera.startPreview();
            this.mProcessingThread = new Thread(this.mFrameProcessor);
            this.mFrameProcessor.setActive(true);
            this.mProcessingThread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mFrameProcessor.setActive(false);
            if (this.mProcessingThread != null) {
                try {
                    this.mProcessingThread.join();
                }
                catch (InterruptedException e) {
                    Log.d((String)TAG, (String)"Frame processing thread interrupted on release.");
                }
                this.mProcessingThread = null;
            }
            this.mBytesToByteBuffer.clear();
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewCallbackWithBuffer(null);
                try {
                    if (Build.VERSION.SDK_INT >= 11) {
                        this.mCamera.setPreviewTexture(null);
                    } else {
                        this.mCamera.setPreviewDisplay(null);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Failed to clear camera preview: " + e));
                }
                this.mCamera.release();
                this.mCamera = null;
            }
        }
    }

    public Size getPreviewSize() {
        return this.mPreviewSize;
    }

    public int getCameraFacing() {
        return this.mFacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doZoom(float scale) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera == null) {
                return 0;
            }
            int currentZoom = 0;
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (!parameters.isZoomSupported()) {
                Log.w((String)TAG, (String)"Zoom is not supported on this device");
                return currentZoom;
            }
            int maxZoom = parameters.getMaxZoom();
            currentZoom = parameters.getZoom() + 1;
            float newZoom = scale > 1.0f ? (float)currentZoom + scale * (float)(maxZoom / 10) : (float)currentZoom * scale;
            currentZoom = Math.round(newZoom) - 1;
            if (currentZoom < 0) {
                currentZoom = 0;
            } else if (currentZoom > maxZoom) {
                currentZoom = maxZoom;
            }
            parameters.setZoom(currentZoom);
            this.mCamera.setParameters(parameters);
            return currentZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutter, PictureCallback jpeg) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                PictureStartCallback startCallback = new PictureStartCallback();
                startCallback.mDelegate = shutter;
                PictureDoneCallback doneCallback = new PictureDoneCallback();
                doneCallback.mDelegate = jpeg;
                this.mCamera.takePicture((Camera.ShutterCallback)startCallback, null, null, (Camera.PictureCallback)doneCallback);
            }
        }
    }

    @Nullable
    public String getFocusMode() {
        return this.mFocusMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFocusMode(@Nullable String mode) {
        Object object = this.mCameraLock;
        synchronized (object) {
            Camera.Parameters parameters;
            if (this.mCamera != null && mode != null && (parameters = this.mCamera.getParameters()).getSupportedFocusModes().contains(mode)) {
                parameters.setFocusMode(mode);
                this.mCamera.setParameters(parameters);
                this.mFocusMode = mode;
                return true;
            }
            return false;
        }
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    @NonNull
    public Object getCameraLock() {
        return this.mCameraLock;
    }

    @Nullable
    public String getFlashMode() {
        return this.mFlashMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFlashMode(@Nullable String mode) {
        Object object = this.mCameraLock;
        synchronized (object) {
            Camera.Parameters parameters;
            List supportedFlashModes;
            if (this.mCamera != null && mode != null && (supportedFlashModes = (parameters = this.mCamera.getParameters()).getSupportedFlashModes()) != null && supportedFlashModes.contains(mode)) {
                parameters.setFlashMode(mode);
                this.mCamera.setParameters(parameters);
                this.mFlashMode = mode;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoFocus(@Nullable AutoFocusCallback cb) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                CameraAutoFocusCallback autoFocusCallback = null;
                if (cb != null) {
                    autoFocusCallback = new CameraAutoFocusCallback();
                    autoFocusCallback.mDelegate = cb;
                }
                this.mCamera.autoFocus(autoFocusCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAutoFocus() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                this.mCamera.cancelAutoFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public boolean setAutoFocusMoveCallback(@Nullable AutoFocusMoveCallback cb) {
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                CameraAutoFocusMoveCallback autoFocusMoveCallback = null;
                if (cb != null) {
                    autoFocusMoveCallback = new CameraAutoFocusMoveCallback();
                    autoFocusMoveCallback.mDelegate = cb;
                }
                this.mCamera.setAutoFocusMoveCallback(autoFocusMoveCallback);
            }
        }
        return true;
    }

    protected CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    protected Camera createCamera() {
        int requestedCameraId = CameraSource.getIdForRequestedCamera(this.mFacing);
        if (requestedCameraId == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)requestedCameraId);
        SizePair sizePair = CameraSource.selectSizePair(camera, this.mRequestedPreviewWidth, this.mRequestedPreviewHeight);
        if (sizePair == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size pictureSize = sizePair.pictureSize();
        this.mPreviewSize = sizePair.previewSize();
        int[] previewFpsRange = this.selectPreviewFpsRange(camera, this.mRequestedFps);
        if (previewFpsRange == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (pictureSize != null) {
            parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        parameters.setPreviewSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
        parameters.setPreviewFpsRange(previewFpsRange[0], previewFpsRange[1]);
        parameters.setPreviewFormat(17);
        this.setRotation(camera, parameters, requestedCameraId);
        if (this.mFocusMode != null) {
            if (parameters.getSupportedFocusModes().contains(this.mFocusMode)) {
                parameters.setFocusMode(this.mFocusMode);
            } else {
                Log.i((String)TAG, (String)("Camera focus mode: " + this.mFocusMode + " is not supported on this device."));
            }
        }
        this.mFocusMode = parameters.getFocusMode();
        if (this.mFlashMode != null) {
            if (parameters.getSupportedFlashModes().contains(this.mFlashMode)) {
                parameters.setFlashMode(this.mFlashMode);
            } else {
                Log.i((String)TAG, (String)("Camera flash mode: " + this.mFlashMode + " is not supported on this device."));
            }
        }
        this.mFlashMode = parameters.getFlashMode();
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new CameraPreviewCallback());
        camera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        return camera;
    }

    protected static int getIdForRequestedCamera(int facing) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != facing) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    protected static SizePair selectSizePair(@NonNull Camera camera, int desiredWidth, int desiredHeight) {
        List<SizePair> validPreviewSizes = CameraSource.generateValidPreviewSizeList(camera);
        SizePair selectedPair = null;
        int minDiff = Integer.MAX_VALUE;
        for (SizePair sizePair : validPreviewSizes) {
            Size size = sizePair.previewSize();
            int diff = Math.abs(size.getWidth() - desiredWidth) + Math.abs(size.getHeight() - desiredHeight);
            if (diff >= minDiff) continue;
            selectedPair = sizePair;
            minDiff = diff;
        }
        return selectedPair;
    }

    @NonNull
    protected static List<SizePair> generateValidPreviewSizeList(@NonNull Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        List supportedPictureSizes = parameters.getSupportedPictureSizes();
        ArrayList<SizePair> validPreviewSizes = new ArrayList<SizePair>();
        block0: for (Camera.Size previewSize : supportedPreviewSizes) {
            float previewAspectRatio = (float)previewSize.width / (float)previewSize.height;
            for (Camera.Size pictureSize : supportedPictureSizes) {
                float pictureAspectRatio = (float)pictureSize.width / (float)pictureSize.height;
                if (!(Math.abs(previewAspectRatio - pictureAspectRatio) < 0.01f)) continue;
                validPreviewSizes.add(new SizePair(previewSize, pictureSize));
                continue block0;
            }
        }
        if (validPreviewSizes.size() == 0) {
            Log.w((String)TAG, (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size previewSize : supportedPreviewSizes) {
                validPreviewSizes.add(new SizePair(previewSize, null));
            }
        }
        return validPreviewSizes;
    }

    @Nullable
    protected int[] selectPreviewFpsRange(@NonNull Camera camera, float desiredPreviewFps) {
        int desiredPreviewFpsScaled = (int)(desiredPreviewFps * 1000.0f);
        int[] selectedFpsRange = null;
        int minDiff = Integer.MAX_VALUE;
        List previewFpsRangeList = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] range : previewFpsRangeList) {
            int deltaMin = desiredPreviewFpsScaled - range[0];
            int deltaMax = desiredPreviewFpsScaled - range[1];
            int diff = Math.abs(deltaMin) + Math.abs(deltaMax);
            if (diff >= minDiff) continue;
            selectedFpsRange = range;
            minDiff = diff;
        }
        return selectedFpsRange;
    }

    protected void setRotation(@NonNull Camera camera, @NonNull Camera.Parameters parameters, int cameraId) {
        int displayAngle;
        int angle;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int degrees = 0;
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Bad rotation value: " + rotation));
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            angle = (cameraInfo.orientation + degrees) % 360;
            displayAngle = 360 - angle;
        } else {
            displayAngle = angle = (cameraInfo.orientation - degrees + 360) % 360;
        }
        this.mRotation = angle / 90;
        camera.setDisplayOrientation(displayAngle);
        parameters.setRotation(angle);
    }

    @NonNull
    protected byte[] createPreviewBuffer(@NonNull Size previewSize) {
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)17);
        long sizeInBits = previewSize.getHeight() * previewSize.getWidth() * bitsPerPixel;
        int bufferSize = (int)Math.ceil((double)sizeInBits / 8.0) + 1;
        byte[] byteArray = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        if (!buffer.hasArray() || buffer.array() != byteArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.mBytesToByteBuffer.put(byteArray, buffer);
        return byteArray;
    }

    public static class Builder {
        @Nullable
        protected final Detector<?> mDetector;
        @Nullable
        protected CameraSource mCameraSource;

        public Builder(@Nullable Context context, @Nullable Detector<?> detector, @Nullable CameraSource cameraSource) {
            CameraSource cameraSource2 = this.mCameraSource = cameraSource != null ? cameraSource : new CameraSource();
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.mDetector = detector;
            this.mCameraSource.mContext = context;
        }

        public Builder(Context context, Detector<?> detector) {
            this(context, detector, null);
        }

        @NonNull
        public Builder setRequestedFps(float fps) {
            if (fps <= 0.0f) {
                throw new IllegalArgumentException("Invalid fps: " + fps);
            }
            this.mCameraSource.mRequestedFps = fps;
            return this;
        }

        @NonNull
        public Builder setFocusMode(String mode) {
            this.mCameraSource.mFocusMode = mode;
            return this;
        }

        @NonNull
        public Builder setFlashMode(String mode) {
            this.mCameraSource.mFlashMode = mode;
            return this;
        }

        @NonNull
        public Builder setRequestedPreviewSize(int width, int height) {
            int MAX = 1000000;
            if (width <= 0 || width > 1000000 || height <= 0 || height > 1000000) {
                throw new IllegalArgumentException("Invalid preview size: " + width + "x" + height);
            }
            this.mCameraSource.mRequestedPreviewWidth = width;
            this.mCameraSource.mRequestedPreviewHeight = height;
            return this;
        }

        @NonNull
        public Builder setFacing(int facing) {
            if (facing != 0 && facing != 1) {
                throw new IllegalArgumentException("Invalid camera: " + facing);
            }
            this.mCameraSource.mFacing = facing;
            return this;
        }

        @Nullable
        public CameraSource build() {
            CameraSource cameraSource = this.mCameraSource;
            cameraSource.getClass();
            this.mCameraSource.mFrameProcessor = cameraSource.new FrameProcessingRunnable(this.mDetector);
            return this.mCameraSource;
        }
    }

    protected class FrameProcessingRunnable
    implements Runnable {
        @Nullable
        protected Detector<?> mDetector;
        protected long mStartTimeMillis = SystemClock.elapsedRealtime();
        protected final Object mLock = new Object();
        protected boolean mActive = true;
        protected long mPendingTimeMillis;
        protected int mPendingFrameId = 0;
        @Nullable
        protected ByteBuffer mPendingFrameData;

        FrameProcessingRunnable(Detector<?> detector) {
            this.mDetector = detector;
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.mProcessingThread.getState() == Thread.State.TERMINATED);
            this.mDetector.release();
            this.mDetector = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.mLock;
            synchronized (object) {
                this.mActive = active;
                this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNextFrame(byte[] data, @NonNull Camera camera) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mPendingFrameData != null) {
                    camera.addCallbackBuffer(this.mPendingFrameData.array());
                    this.mPendingFrameData = null;
                }
                if (!CameraSource.this.mBytesToByteBuffer.containsKey(data)) {
                    Log.d((String)CameraSource.TAG, (String)"Skipping frame.  Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.mPendingTimeMillis = SystemClock.elapsedRealtime() - this.mStartTimeMillis;
                ++this.mPendingFrameId;
                this.mPendingFrameData = CameraSource.this.mBytesToByteBuffer.get(data);
                this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ByteBuffer data;
                Frame outputFrame;
                Object object = this.mLock;
                synchronized (object) {
                    while (this.mActive && this.mPendingFrameData == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException e) {
                            Log.d((String)CameraSource.TAG, (String)"Frame processing loop terminated.", (Throwable)e);
                            return;
                        }
                    }
                    if (!this.mActive) {
                        return;
                    }
                    outputFrame = new Frame.Builder().setImageData(this.mPendingFrameData, CameraSource.this.mPreviewSize.getWidth(), CameraSource.this.mPreviewSize.getHeight(), 17).setId(this.mPendingFrameId).setTimestampMillis(this.mPendingTimeMillis).setRotation(CameraSource.this.mRotation).build();
                    data = this.mPendingFrameData;
                    this.mPendingFrameData = null;
                }
                try {
                    this.mDetector.receiveFrame(outputFrame);
                    continue;
                }
                catch (Throwable t) {
                    Log.e((String)CameraSource.TAG, (String)"Exception thrown from receiver.", (Throwable)t);
                    continue;
                }
                finally {
                    CameraSource.this.mCamera.addCallbackBuffer(data.array());
                    continue;
                }
                break;
            }
        }
    }

    protected class CameraPreviewCallback
    implements Camera.PreviewCallback {
        protected CameraPreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, @NonNull Camera camera) {
            CameraSource.this.mFrameProcessor.setNextFrame(data, camera);
        }
    }

    protected static class SizePair {
        protected Size mPreview;
        protected Size mPicture;

        public SizePair(@NonNull Camera.Size previewSize, @Nullable Camera.Size pictureSize) {
            this.mPreview = new Size(previewSize.width, previewSize.height);
            if (pictureSize != null) {
                this.mPicture = new Size(pictureSize.width, pictureSize.height);
            }
        }

        public Size previewSize() {
            return this.mPreview;
        }

        public Size pictureSize() {
            return this.mPicture;
        }
    }

    @TargetApi(value=16)
    protected class CameraAutoFocusMoveCallback
    implements Camera.AutoFocusMoveCallback {
        @Nullable
        protected AutoFocusMoveCallback mDelegate;

        protected CameraAutoFocusMoveCallback() {
        }

        public void onAutoFocusMoving(boolean start, Camera camera) {
            if (this.mDelegate != null) {
                this.mDelegate.onAutoFocusMoving(start);
            }
        }
    }

    protected class CameraAutoFocusCallback
    implements Camera.AutoFocusCallback {
        @Nullable
        protected AutoFocusCallback mDelegate;

        protected CameraAutoFocusCallback() {
        }

        public void onAutoFocus(boolean success, Camera camera) {
            if (this.mDelegate != null) {
                this.mDelegate.onAutoFocus(success);
            }
        }
    }

    protected class PictureDoneCallback
    implements Camera.PictureCallback {
        protected PictureCallback mDelegate;

        protected PictureDoneCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] data, Camera camera) {
            if (this.mDelegate != null) {
                this.mDelegate.onPictureTaken(data);
            }
            Object object = CameraSource.this.mCameraLock;
            synchronized (object) {
                if (CameraSource.this.mCamera != null) {
                    CameraSource.this.mCamera.startPreview();
                }
            }
        }
    }

    protected class PictureStartCallback
    implements Camera.ShutterCallback {
        protected ShutterCallback mDelegate;

        protected PictureStartCallback() {
        }

        public void onShutter() {
            if (this.mDelegate != null) {
                this.mDelegate.onShutter();
            }
        }
    }

    public static interface AutoFocusMoveCallback {
        public void onAutoFocusMoving(boolean var1);
    }

    public static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1);
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }
}

