/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.vision;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.MultiProcessor;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import com.inverce.mod.core.IM;
import com.inverce.mod.vision.R;
import com.inverce.mod.vision.adapters.BarcodeTrackerFactory;
import com.inverce.mod.vision.camera.CameraSource;
import com.inverce.mod.vision.camera.CameraSourcePreview;
import com.inverce.mod.vision.camera.Permissions;
import com.inverce.mod.vision.interfaces.NewDetectionListener;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class VisionScannerFragment
extends Fragment {
    public static final int RC_HANDLE_GMS = 9207;
    public static final int RC_HANDLE_CAMERA_PERM = 9208;
    private static final String TAG = "IM.Barcode";
    @Nullable
    protected BarcodeDetector barcodeDetector;
    @Nullable
    protected CameraSource mCameraSource;
    @Nullable
    protected CameraSourcePreview mCameraSourcePreview;
    protected int barcodeFormats = 0;
    protected NewDetectionListener detectionListener;
    @Nullable
    protected ScheduledFuture<?> selfFocus;
    protected boolean mDetectionConsumed = false;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.inverce_barcode_scanner, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mCameraSourcePreview = (CameraSourcePreview)view.findViewById(R.id.inverce_camera_preview);
    }

    public BarcodeDetector onCreateBarcodeDetector(Activity activity) {
        return new BarcodeDetector.Builder((Context)activity).setBarcodeFormats(this.barcodeFormats).build();
    }

    @Nullable
    public CameraSource onCreateCameraSource(Activity activity, BarcodeDetector barcodeDetector) {
        return new CameraSource.Builder((Context)activity, (Detector<?>)barcodeDetector).setFacing(0).setFlashMode(null).setFocusMode("continuous-picture").build();
    }

    @NonNull
    public VisionScannerFragment setBarcodeFormats(int barcodeFormats) {
        this.barcodeFormats = barcodeFormats;
        return this;
    }

    @NonNull
    public VisionScannerFragment setDetectionListener(NewDetectionListener detectionListener) {
        this.detectionListener = detectionListener;
        return this;
    }

    public void initialize() {
        this.barcodeDetector = this.onCreateBarcodeDetector((Activity)this.getActivity());
        this.mCameraSource = this.onCreateCameraSource((Activity)this.getActivity(), this.barcodeDetector);
    }

    public void onStart() {
        super.onStart();
        this.initialize();
    }

    public void onStop() {
        super.onStop();
    }

    public void onResume() {
        super.onResume();
        if (Permissions.hasPermissions(Permissions.CAMERA_PERMISSIONS, (Activity)this.getActivity())) {
            this.startCameraSource();
        }
        IM.onBg().schedule(this::checkUpFocus, 3L, TimeUnit.SECONDS);
    }

    public void onPause() {
        super.onPause();
        if (this.mCameraSourcePreview != null) {
            this.mCameraSourcePreview.stop();
        }
        if (this.selfFocus != null) {
            this.selfFocus.cancel(false);
            this.selfFocus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpFocus() {
        block6: {
            try {
                if (this.mCameraSource == null || this.mCameraSource.getCamera() == null || this.mCameraSource.getCamera().getParameters() == null) break block6;
                Object object = this.mCameraSource.getCameraLock();
                synchronized (object) {
                    if (!this.mCameraSource.getCamera().getParameters().getSupportedFocusModes().contains("continuous-picture")) {
                        this.mCameraSource.setFocusMode("auto");
                        this.selfFocus = IM.onUi().scheduleAtFixedRate(this::tryFocus, 0L, 3L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("camera: " + e.toString()));
            }
        }
    }

    private void tryFocus() {
        try {
            if (this.mCameraSource != null) {
                this.mCameraSource.autoFocus(null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public CameraSource getCameraSource() {
        return this.mCameraSource;
    }

    private void startCameraSource() throws SecurityException {
        int code = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext());
        if (code != 0 && this.getActivity() != null) {
            Dialog dialog = GoogleApiAvailability.getInstance().getErrorDialog((Activity)this.getActivity(), code, 9207);
            dialog.show();
        }
        if (this.mCameraSource != null && this.barcodeDetector != null) {
            try {
                BarcodeTrackerFactory barcodeFactory = new BarcodeTrackerFactory(p -> {
                    if (this.detectionListener != null) {
                        this.detectionListener.onNewDetection(p);
                    }
                });
                this.barcodeDetector.setProcessor((Detector.Processor)new MultiProcessor.Builder((MultiProcessor.Factory)barcodeFactory).build());
                this.mCameraSourcePreview.start(this.mCameraSource);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to start camera source.", (Throwable)e);
                this.mCameraSource.release();
                this.mCameraSource = null;
            }
        }
    }

    public void setTorch(boolean enabled) {
        try {
            if (this.checkPermissions(this.getContext(), false) && this.mCameraSource != null) {
                this.mCameraSource.setFlashMode(enabled ? "torch" : "off");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isTorchEnabled() {
        try {
            return this.mCameraSource != null && "off".equals(this.mCameraSource.getFlashMode());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkPermissions(@Nullable Context context, boolean requestIfNotPresent) {
        if (context == null) {
            return false;
        }
        int mCameraPermission = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA");
        if (mCameraPermission != 0) {
            if (requestIfNotPresent && context instanceof Activity) {
                this.requestCameraPermission((Activity)context, true);
            }
            return false;
        }
        return true;
    }

    public void requestCameraPermission(final @NonNull Activity context, boolean showSnackBarRationale) {
        final String[] mPermissions = new String[]{"android.permission.CAMERA"};
        if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)context, (String)"android.permission.CAMERA")) {
            ActivityCompat.requestPermissions((Activity)context, (String[])mPermissions, (int)9208);
            return;
        }
        if (!showSnackBarRationale) {
            ActivityCompat.requestPermissions((Activity)context, (String[])mPermissions, (int)9208);
        } else if (this.getView() != null) {
            View.OnClickListener listener = new View.OnClickListener(){

                public void onClick(View view) {
                    ActivityCompat.requestPermissions((Activity)context, (String[])mPermissions, (int)9208);
                }
            };
            Snackbar.make((View)this.getView(), (int)R.string.im_permission_camera_rationale, (int)-2).setAction(17039370, listener).show();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.isRemoving()) {
            this.clean();
        }
    }

    private void clean() {
        if (this.mCameraSourcePreview != null) {
            this.mCameraSourcePreview.release();
            this.mCameraSourcePreview = null;
        }
    }
}

