/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.vision.camera;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.images.Size;
import com.inverce.mod.vision.camera.CameraSource;
import java.io.IOException;

public class CameraSourcePreview
extends ViewGroup {
    private static final String TAG = "CameraSourcePreview";
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private CameraSource mCameraSource;

    public CameraSourcePreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void start(CameraSource cameraSource) throws IOException, SecurityException {
        if (cameraSource == null) {
            this.stop();
        }
        this.mCameraSource = cameraSource;
        if (this.mCameraSource != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    public void stop() {
        if (this.mCameraSource != null) {
            this.mCameraSource.stop();
        }
    }

    public void release() {
        if (this.mCameraSource != null) {
            this.mCameraSource.release();
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private void startIfReady() throws IOException, SecurityException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCameraSource.start(this.mSurfaceView.getHolder());
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childHeight;
        int childWidth;
        Size size;
        int previewWidth = 320;
        int previewHeight = 240;
        if (this.mCameraSource != null && (size = this.mCameraSource.getPreviewSize()) != null) {
            previewWidth = size.getWidth();
            previewHeight = size.getHeight();
        }
        if (this.isPortraitMode()) {
            int tmp = previewWidth;
            previewWidth = previewHeight;
            previewHeight = tmp;
        }
        int viewWidth = right - left;
        int viewHeight = bottom - top;
        int childXOffset = 0;
        int childYOffset = 0;
        float widthRatio = (float)viewWidth / (float)previewWidth;
        float heightRatio = (float)viewHeight / (float)previewHeight;
        if (widthRatio > heightRatio) {
            childWidth = viewWidth;
            childHeight = (int)((float)previewHeight * widthRatio);
            childYOffset = (childHeight - viewHeight) / 2;
        } else {
            childWidth = (int)((float)previewWidth * heightRatio);
            childHeight = viewHeight;
            childXOffset = (childWidth - viewWidth) / 2;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(-1 * childXOffset, -1 * childYOffset, childWidth - childXOffset, childHeight - childYOffset);
        }
        try {
            this.startIfReady();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Could not start camera source.", (Throwable)e);
        }
    }

    private boolean isPortraitMode() {
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return false;
        }
        if (orientation == 1) {
            return true;
        }
        Log.d((String)TAG, (String)"isPortraitMode returning false by default");
        return false;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = true;
            try {
                CameraSourcePreview.this.startIfReady();
            }
            catch (SecurityException se) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Do not have permission to start the camera", (Throwable)se);
            }
            catch (IOException e) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

