/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.processing;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.inverce.mod.core.IM;
import com.inverce.mod.core.functional.IConsumer;
import com.inverce.mod.core.threadpool.NamedThreadPool;
import com.inverce.mod.core.verification.Preconditions;
import com.inverce.mod.processing.Job;
import com.inverce.mod.processing.JobResult;
import com.inverce.mod.processing.Processor;
import com.inverce.mod.processing.QueueListener;
import com.inverce.mod.processing.QueueListenerAdapter;
import com.inverce.mod.processing.TaskMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ProcessingQueue {
    protected List<Job<?, ?>> processing;
    protected List<Job<?, ?>> awaiting = Collections.synchronizedList(new ArrayList());
    protected List<Thread> activeThreads = Collections.synchronizedList(new ArrayList());
    protected Settings cfg;
    protected QueueListener events;

    public static ProcessingQueue create() {
        return new ProcessingQueue();
    }

    private ProcessingQueue() {
        this.processing = Collections.synchronizedList(new ArrayList());
        this.events = new QueueListenerAdapter();
        this.cfg = new Settings();
        this.cfg.asynchronous = true;
        this.cfg.failureAction = FailureAction.ABORT;
        this.cfg.threadFactory = new NamedThreadPool("ProcessingQueue#" + this.hashCode());
    }

    @NonNull
    public ProcessingQueue setAsynchronous(boolean asynchronous) {
        Preconditions.checkState((!this.cfg.isStarted ? 1 : 0) != 0, (Object)"ProcessingQueue already isStarted");
        this.cfg.asynchronous = asynchronous;
        return this;
    }

    @NonNull
    public ProcessingQueue setPoolSize(int poolSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be greater than 0");
        this.cfg.poolSize = poolSize;
        return this;
    }

    @NonNull
    public ProcessingQueue setFailureAction(FailureAction failureAction) {
        Preconditions.checkState((!this.cfg.isStarted ? 1 : 0) != 0, (Object)"ProcessingQueue already isStarted");
        this.cfg.failureAction = failureAction;
        return this;
    }

    @NonNull
    public ProcessingQueue setThreadFactory(@NonNull ThreadFactory threadFactory) {
        Preconditions.checkState((!this.cfg.isStarted ? 1 : 0) != 0, (Object)"ProcessingQueue already isStarted");
        Preconditions.checkNotNull((Object)threadFactory, (Object)"Factory cannot be null");
        this.cfg.threadFactory = threadFactory;
        return this;
    }

    @NonNull
    public ProcessingQueue setContinuous(boolean continuous) {
        Preconditions.checkState((!this.cfg.isStarted ? 1 : 0) != 0, (Object)"ProcessingQueue already isStarted");
        this.cfg.isContinuous = continuous;
        return this;
    }

    public List<Job<?, ?>> getProcessing() {
        return Collections.unmodifiableList(new ArrayList(this.processing));
    }

    public List<Job<?, ?>> getAwaiting() {
        return Collections.unmodifiableList(new ArrayList(this.awaiting));
    }

    @NonNull
    public ProcessingQueue setListener(@Nullable QueueListener events) {
        this.events = events == null ? new QueueListenerAdapter() : events;
        return this;
    }

    @NonNull
    public <T> ProcessingQueue processTask(@NonNull TaskMapper<T> handler, @NonNull List<T> list) {
        return this.processInternal(Processor.EX.map(Processor.RUNNABLES, handler::processJob), list, false);
    }

    @NonNull
    public <T> ProcessingQueue process(@NonNull IConsumer<T> handler, @NonNull List<T> list) {
        return this.processInternal(Processor.EX.map(Processor.RUNNABLES, o -> () -> handler.accept(o)), list, false);
    }

    @NonNull
    public <T, R> ProcessingQueue process(@NonNull Processor<T, R> processor, @NonNull List<T> list) {
        return this.processInternal(processor, list, false);
    }

    @NonNull
    public <T> ProcessingQueue processTaskIfNotAdded(@NonNull TaskMapper<T> handler, @NonNull List<T> list) {
        return this.processInternal(Processor.EX.map(Processor.RUNNABLES, handler::processJob), list, true);
    }

    @NonNull
    public <T> ProcessingQueue processIfNotAdded(@NonNull IConsumer<T> handler, @NonNull List<T> list) {
        return this.processInternal(Processor.EX.map(Processor.RUNNABLES, o -> () -> handler.accept(o)), list, true);
    }

    @NonNull
    public <T, R> ProcessingQueue processIfNotAdded(@NonNull Processor<T, R> processor, @NonNull List<T> list) {
        return this.processInternal(processor, list, true);
    }

    @NonNull
    <T, R> ProcessingQueue processInternal(@NonNull Processor<T, R> processor, @NonNull List<T> list, boolean checkExist) {
        Preconditions.checkNotNull(processor, (Object)"Processor connot be null");
        Preconditions.checkNotNull(list, (Object)"You must specify elements");
        Preconditions.checkArgument((!this.cfg.isCancelled ? 1 : 0) != 0, (Object)"Cant add task to cancelled queue");
        Preconditions.checkArgument((!this.cfg.isDone || this.cfg.isContinuous ? 1 : 0) != 0, (Object)"Adding more task after queue started supported with continous mode");
        for (T item : list) {
            if (checkExist && this.contains(item)) continue;
            this.awaiting.add(new Job<T, R>(item, processor));
        }
        if (this.cfg.isContinuous && this.cfg.isStarted) {
            IM.onBg().execute(this::fillQueue);
        }
        return this;
    }

    public boolean isStarted() {
        return this.cfg.isStarted;
    }

    public boolean isCancelled() {
        return this.cfg.isCancelled;
    }

    public boolean isFinished() {
        return this.cfg.isDone && !this.cfg.isContinuous;
    }

    public synchronized void start() {
        Preconditions.checkArgument((!this.cfg.isStarted ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.cfg.isDone ? 1 : 0) != 0);
        Preconditions.checkArgument((this.awaiting.size() > 0 ? 1 : 0) != 0, (Object)"You need to add at least one item to process");
        this.cfg.isStarted = true;
        IM.onBg().execute(this::fillQueue);
        this.events.onQueueStarted(this);
    }

    @WorkerThread
    private synchronized boolean offerJob(@NonNull Job<?, ?> job) {
        Thread thread;
        int max;
        int n = max = this.cfg.asynchronous ? this.cfg.poolSize : 1;
        if (this.processing.size() >= max) {
            return false;
        }
        this.awaiting.remove(job);
        this.processing.add(job);
        job.thread = thread = this.cfg.threadFactory.newThread(() -> job.accept(this));
        thread.start();
        this.activeThreads.add(thread);
        this.events.onJobStarted(this, job.item, job.processor);
        return true;
    }

    @WorkerThread
    synchronized void finishJob(@NonNull JobResult<?, ?> jobResult) {
        this.processing.remove(jobResult.job);
        this.activeThreads.remove(jobResult.job.thread);
        if (jobResult.exception == null) {
            this.events.onJobResult(this, jobResult.job, jobResult.result);
        } else {
            this.events.onJobFailure(this, jobResult.job, jobResult.exception);
        }
        if (jobResult.exception != null && this.cfg.failureAction == FailureAction.ABORT) {
            this.cancel();
            this.cfg.isDone = true;
            return;
        }
        if (this.awaiting.size() > 0 && !this.cfg.isCancelled) {
            this.fillQueue();
        }
        if (this.processing.size() == 0 && this.awaiting.size() == 0 && !this.cfg.isCancelled) {
            this.cfg.isDone = true;
            this.events.onQueueFinished(this);
        }
    }

    @WorkerThread
    private synchronized void fillQueue() {
        if (this.cfg.asynchronous) {
            for (Job<?, ?> job : new ArrayList(this.awaiting)) {
                if (!this.offerJob(job)) break;
            }
        } else {
            this.offerJob(this.awaiting.get(0));
        }
    }

    public synchronized boolean contains(Object item) {
        for (Job<?, ?> job : new ArrayList(this.processing)) {
            if (!job.getItem().equals(item)) continue;
            return true;
        }
        for (Job<?, ?> job : new ArrayList(this.awaiting)) {
            if (!job.getItem().equals(item)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cancelItem(Object item) {
        for (Job<?, ?> job : new ArrayList(this.awaiting)) {
            if (!job.getItem().equals(item)) continue;
            this.awaiting.remove(job);
            return true;
        }
        for (Job<?, ?> job : new ArrayList(this.processing)) {
            if (!job.getItem().equals(item)) continue;
            Thread thread = job.getThread();
            synchronized (thread) {
                job.getThread().interrupt();
            }
            this.activeThreads.remove(job.thread);
            this.processing.remove(job);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        this.cfg.isCancelled = true;
        this.cfg.isFinishing = true;
        this.cfg.isStarted = false;
        this.cfg.isDone = !this.cfg.isContinuous;
        Iterator<Thread> iterator = this.activeThreads.iterator();
        while (iterator.hasNext()) {
            Thread t;
            Thread thread = t = iterator.next();
            synchronized (thread) {
                t.interrupt();
            }
        }
        this.activeThreads.clear();
        IM.onBg().schedule(() -> {
            this.events.onQueueCancelled(this);
            this.cfg.isFinishing = false;
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private static class Settings {
        boolean asynchronous;
        boolean isContinuous;
        boolean isStarted;
        boolean isCancelled;
        boolean isDone;
        boolean isFinishing;
        boolean isWaitingToStart;
        FailureAction failureAction;
        ThreadFactory threadFactory;
        int poolSize = 8;

        private Settings() {
        }
    }

    public static enum FailureAction {
        ABORT,
        IGNORE;

    }
}

