/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.processing;

import android.support.annotation.NonNull;
import com.inverce.mod.core.IM;
import com.inverce.mod.core.functional.IConsumer;
import com.inverce.mod.processing.JobResult;
import com.inverce.mod.processing.ProcessingQueue;
import com.inverce.mod.processing.Processor;

public class Job<ITEM, RESULT>
implements IConsumer<ProcessingQueue> {
    protected ITEM item;
    protected Processor<ITEM, RESULT> processor;
    protected Thread thread;

    public Job(ITEM item, Processor<ITEM, RESULT> processor) {
        this.item = item;
        this.processor = processor;
    }

    public void accept(@NonNull ProcessingQueue queue) {
        try {
            RESULT result = this.processor.processJob(this.item);
            IM.onBg().execute(() -> queue.finishJob(new JobResult(this, result)));
        }
        catch (Exception ex) {
            IM.onBg().execute(() -> queue.finishJob(new JobResult(this, ex)));
        }
    }

    public ITEM getItem() {
        return this.item;
    }

    public Processor<ITEM, RESULT> getProcessor() {
        return this.processor;
    }

    public Thread getThread() {
        return this.thread;
    }
}

