/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.events;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inverce.mod.core.Log;
import com.inverce.mod.core.collections.WeakArrayList;
import com.inverce.mod.events.AsyncResult;
import com.inverce.mod.events.Channel;
import com.inverce.mod.events.ChannelGroup;
import com.inverce.mod.events.DefaultUiExecutor;
import com.inverce.mod.events.annotation.EventInfo;
import com.inverce.mod.events.annotation.Listener;
import com.inverce.mod.events.interfaces.EventCaller;
import com.inverce.mod.events.interfaces.MultiEvent;
import com.inverce.mod.events.interfaces.SingleEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Event<T extends Listener>
implements SingleEvent<T>,
MultiEvent<T>,
EventCaller<T>,
InvocationHandler {
    protected Class<T> service;
    @NonNull
    protected final List<T> list;
    @NonNull
    protected final T proxyCaller;
    protected boolean needCleanUp;
    protected static Executor uiExecutor = new DefaultUiExecutor();
    protected static Executor bgExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public Event(Class<T> clazz) {
        this(clazz, true);
    }

    public Event(Class<T> clazz, boolean useWeakReferences) {
        this.service = clazz;
        this.list = useWeakReferences ? new WeakArrayList() : new ArrayList<T>(1);
        this.proxyCaller = (Listener)Proxy.newProxyInstance(this.service.getClassLoader(), new Class[]{this.service}, (InvocationHandler)this);
    }

    private void cleanUp(@Nullable T listener) {
        int cleared = 0;
        if (listener != null) {
            cleared += this.list.remove(listener) ? 1 : 0;
        }
        if (this.list instanceof WeakArrayList) {
            cleared += ((WeakArrayList)this.list).clearEmptyReferences();
        }
        if (this.needCleanUp) {
            Log.e((String)this.service.getSimpleName(), (String)("Cleaned up references " + cleared));
        }
        this.needCleanUp = false;
    }

    void addListenerInternal(Object listener) {
        if (this.service.isInstance(listener)) {
            this.addListener((T)((Listener)listener));
        }
    }

    void removeListenerInternal(Object listener) {
        if (this.service.isInstance(listener)) {
            this.removeListener((T)((Listener)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(@Nullable T listener) {
        List<T> list = this.list;
        synchronized (list) {
            this.list.clear();
            if (listener != null) {
                this.list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@Nullable T listener) {
        if (listener != null) {
            List<T> list = this.list;
            synchronized (list) {
                if (!this.list.contains(listener)) {
                    this.list.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(T listener) {
        List<T> list = this.list;
        synchronized (list) {
            this.cleanUp(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<T> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public T post() {
        List<T> list = this.list;
        synchronized (list) {
            return this.proxyCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        List<T> list = this.list;
        synchronized (list) {
            return this.list.size();
        }
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, @NonNull Method method, Object[] args) throws Throwable {
        EventInfo onThread = method.getAnnotation(EventInfo.class);
        if (onThread != null) {
            switch (onThread.thread()) {
                case BgThread: {
                    bgExecutor.execute(this.createInvokerRunnable(null, method, args));
                    return null;
                }
                case UiThread: {
                    uiExecutor.execute(this.createInvokerRunnable(null, method, args));
                    return null;
                }
            }
        }
        return this.invokeInternal(null, method, args);
    }

    private Runnable createInvokerRunnable(final AsyncResult<T> proxy, final @NonNull Method method, final Object[] args) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Event.this.invokeInternal(proxy, method, args);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object invokeInternal(AsyncResult<T> result, @NonNull Method method, Object[] args) throws Throwable {
        List<T> list = this.list;
        synchronized (list) {
            Object[] returns = new Object[this.list.size()];
            for (int i = 0; i < this.list.size(); ++i) {
                Listener listener = (Listener)this.list.get(i);
                if (listener != null) {
                    returns[i] = method.invoke((Object)listener, args);
                    continue;
                }
                this.needCleanUp = true;
            }
            if (this.needCleanUp) {
                this.cleanUp(null);
            }
            return this.list.size() > 0 ? returns[0] : null;
        }
    }

    public static class Bus {
        static Channel defaultChannel;
        static ChannelGroup channels;
        static long tsLastRegister;
        static long tsLastNotify;
        static long tsLastCount;
        static long hashLastRegister;
        static long tsTimeNotify;

        private static void handleRegisterHint(@Nullable Object listener) {
            if (Log.isLoggable((int)4) && listener != null) {
                int hash = listener.hashCode();
                if (hashLastRegister != (long)hash) {
                    tsLastRegister = 0L;
                    hashLastRegister = hash;
                    tsLastCount = 0L;
                    return;
                }
                long ts = System.currentTimeMillis();
                if (ts - tsLastRegister < 15L && ts - tsLastNotify > tsTimeNotify && ++tsLastCount > 2L) {
                    Log.i((String)"Consider using Bus.registerAll for registering multiple event on same object.");
                    tsLastNotify = ts;
                }
                tsLastRegister = ts;
                hashLastRegister = hash;
            }
        }

        public static <T extends Listener> void registerAll(T listener) {
            Bus.channel().registerAll(listener);
        }

        public static <T extends Listener> void unregisterAll(T listener) {
            Bus.channel().unregisterAll(listener);
        }

        public static <T extends Listener> void register(Class<T> clazz, T listener) {
            Bus.handleRegisterHint(listener);
            Bus.channel().event(clazz).addListener(listener);
        }

        public static <T extends Listener> void registerSingle(Class<T> clazz, T listener) {
            Bus.channel().event(clazz).setListener(listener);
        }

        public static <T extends Listener> void unregister(Class<T> clazz, T listener) {
            Bus.channel().event(clazz).removeListener(listener);
        }

        @NonNull
        public static <T extends Listener> T post(Class<T> clazz) {
            return (T)Bus.channel().event(clazz).post();
        }

        public static synchronized <T extends Listener> Event<T> event(Class<T> clazz) {
            return Bus.channel().event(clazz);
        }

        public static Channel channel(int channelId) {
            if (channels == null) {
                channels = new ChannelGroup(true);
            }
            return channels.on(channelId);
        }

        private static Channel channel() {
            if (defaultChannel == null) {
                defaultChannel = new Channel(true);
            }
            return defaultChannel;
        }

        static {
            tsLastRegister = 0L;
            tsLastNotify = 0L;
            tsLastCount = 0L;
            hashLastRegister = 0L;
            tsTimeNotify = 2000L;
        }
    }
}

